/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.controller;

import com.shuxi.base.vo.ActionResult;
import com.shuxi.domain.Production;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/production"})
public class ProductionController {
    @GetMapping(value={"/download-template"})
    public ResponseEntity<InputStreamResource> downloadTemplate() throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        Sheet sheet = workbook.createSheet("\u6a21\u677f");
        Row headerRow = sheet.createRow(0);
        headerRow.createCell(0).setCellValue("\u4e61\u9547\u540d");
        headerRow.createCell(1).setCellValue("\u79cd\u690d\u9762\u79ef\uff08\u4ea9\uff09");
        headerRow.createCell(2).setCellValue("\u79cd\u690d\u4ea7\u91cf\uff08\u5428\uff09");
        Row dataRow1 = sheet.createRow(1);
        dataRow1.createCell(0).setCellValue("\u65b0\u5b81\u9547");
        dataRow1.createCell(1).setCellValue("123");
        dataRow1.createCell(2).setCellValue("234");
        for (int i = 0; i < 2; ++i) {
            sheet.autoSizeColumn(i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook.write((OutputStream)out);
        workbook.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = "\u5bfc\u5165\u6a21\u677f_" + timestamp + ".xls";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=" + fileName);
        headers.add("Content-Type", "text/plain;charset=utf-8");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.parseMediaType((String)"application/vnd.ms-excel")).body((Object)new InputStreamResource((InputStream)in));
    }

    @PostMapping(value={"/import"})
    public ActionResult<String> importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="year") String year) {
        if (file.isEmpty()) {
            return ActionResult.fail((String)"\u6587\u4ef6\u4e3a\u7a7a");
        }
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(file.getInputStream());
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (row.getRowNum() == 0) continue;
                Production production = new Production();
                production.setYear(year);
                production.setTownship(row.getCell(0).getStringCellValue());
                production.setYield(Double.valueOf(row.getCell(1).getNumericCellValue()));
            }
            workbook.close();
            return ActionResult.success((String)"\u6587\u4ef6\u5bfc\u5165\u6210\u529f");
        }
        catch (IOException e) {
            e.printStackTrace();
            return ActionResult.fail((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25");
        }
    }
}

