/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.controller;

import com.shuxi.base.vo.ActionResult;
import com.shuxi.domain.TownshipOutput;
import com.shuxi.service.TownshipOutputService;
import com.shuxi.util.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/townshipOutput"})
public class TownshipOutputController {
    @Autowired
    private TownshipOutputService townshipOutputService;

    @Transactional
    @PostMapping(value={"/add"})
    public ActionResult create(@RequestBody List<TownshipOutput> list) {
        int result = this.townshipOutputService.insert(list);
        if (result == 0) {
            return ActionResult.fail((String)"\u65b0\u589e\u5931\u8d25");
        }
        return ActionResult.success();
    }

    @PutMapping(value={"/update"})
    public ActionResult update(@RequestBody List<TownshipOutput> list) {
        int result = this.townshipOutputService.update(list);
        if (result == 0) {
            return ActionResult.fail((String)"\u4fee\u6539\u5931\u8d25");
        }
        return ActionResult.success();
    }

    @GetMapping(value={"/list"})
    public ActionResult list() {
        HashMap<String, List> map = new HashMap<String, List>();
        int year = DateUtils.getNowYear();
        map.put("data1", this.townshipOutputService.queryAll(String.valueOf(year - 3)));
        map.put("data2", this.townshipOutputService.queryAll(String.valueOf(year - 2)));
        map.put("data3", this.townshipOutputService.queryAll(String.valueOf(year - 1)));
        return ActionResult.success(map);
    }

    @GetMapping(value={"/download-template"})
    public ResponseEntity<InputStreamResource> downloadTemplate() throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        Sheet sheet = workbook.createSheet("\u6a21\u677f");
        Row headerRow = sheet.createRow(0);
        headerRow.createCell(0).setCellValue("\u4e61\u9547\u540d");
        headerRow.createCell(1).setCellValue("\u79cd\u690d\u9762\u79ef\uff08\u4ea9\uff09");
        headerRow.createCell(2).setCellValue("\u79cd\u690d\u4ea7\u91cf\uff08\u5428\uff09");
        Row dataRow1 = sheet.createRow(1);
        dataRow1.createCell(0).setCellValue("\u65b0\u5b81\u9547");
        dataRow1.createCell(1).setCellValue("123");
        dataRow1.createCell(2).setCellValue("234");
        for (int i = 0; i < 2; ++i) {
            sheet.autoSizeColumn(i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook.write((OutputStream)out);
        workbook.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        String fileName = "\u5404\u533a\u4ea7\u91cf\u7edf\u8ba1\u6a21\u7248.xls";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=" + fileName);
        headers.add("Content-Type", "text/plain;charset=utf-8");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.parseMediaType((String)"application/vnd.ms-excel")).body((Object)new InputStreamResource((InputStream)in));
    }

    @PostMapping(value={"/import"})
    public ActionResult<String> importExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="year") String year) {
        if (file.isEmpty()) {
            return ActionResult.fail((String)"\u6587\u4ef6\u4e3a\u7a7a");
        }
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(file.getInputStream());
            Sheet sheet = workbook.getSheetAt(0);
            ArrayList<TownshipOutput> list = new ArrayList<TownshipOutput>();
            for (Row row : sheet) {
                if (row.getRowNum() == 0) continue;
                TownshipOutput eo = new TownshipOutput();
                eo.setYear(year);
                eo.setTown(row.getCell(0).getStringCellValue());
                eo.setArea(String.valueOf(row.getCell(1).getNumericCellValue()));
                eo.setYield(String.valueOf(row.getCell(2).getNumericCellValue()));
                list.add(eo);
            }
            workbook.close();
            this.townshipOutputService.deleteAll(year);
            this.townshipOutputService.insert(list);
            return ActionResult.success((String)"\u6587\u4ef6\u5bfc\u5165\u6210\u529f");
        }
        catch (IOException e) {
            e.printStackTrace();
            return ActionResult.fail((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25");
        }
    }

    @PostMapping(value={"/importAll"})
    public ActionResult<String> importAll(@RequestParam(value="files") MultipartFile[] files, @RequestParam(value="years") String[] years) {
        if (files.length == 0) {
            return ActionResult.fail((String)"\u6587\u4ef6\u4e3a\u7a7a");
        }
        try {
            for (int i = 0; i < files.length; ++i) {
                MultipartFile file = files[i];
                String year = years[i];
                String filename = file.getOriginalFilename();
                Object workbook = filename != null && filename.toLowerCase().endsWith(".xlsx") ? new XSSFWorkbook(file.getInputStream()) : new HSSFWorkbook(new POIFSFileSystem(file.getInputStream()));
                Sheet sheet = workbook.getSheetAt(0);
                ArrayList<TownshipOutput> list1 = new ArrayList<TownshipOutput>();
                for (Row row : sheet) {
                    if (row.getRowNum() == 0) continue;
                    TownshipOutput eo = new TownshipOutput();
                    eo.setYear(year);
                    eo.setTown(row.getCell(0) == null ? "" : row.getCell(0).getStringCellValue());
                    eo.setArea(String.valueOf(row.getCell(1) == null ? "" : Double.valueOf(row.getCell(1).getNumericCellValue())));
                    eo.setYield(String.valueOf(row.getCell(2) == null ? "" : Double.valueOf(row.getCell(2).getNumericCellValue())));
                    list1.add(eo);
                }
                workbook.close();
                this.townshipOutputService.deleteAll(year);
                this.townshipOutputService.insert(list1);
            }
            return ActionResult.success((String)"\u6587\u4ef6\u5bfc\u5165\u6210\u529f");
        }
        catch (IOException e) {
            e.printStackTrace();
            return ActionResult.fail((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25");
        }
    }
}

