/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HexStringUtil {
    private static final char[] HEX_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Map<Character, Byte> HEX_BYTE_MAP = new HashMap();

    public static String byteArrayToHexString(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            sb.append(HEX_CHAR_TABLE[(b & 0xF0) >> 4]);
            sb.append(HEX_CHAR_TABLE[b & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String hexString) {
        if (StringUtils.isBlank((CharSequence)hexString)) {
            return null;
        }
        byte[] byteArray = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length() / 2; ++i) {
            char hi = hexString.charAt(i * 2);
            char lo = hexString.charAt(i * 2 + 1);
            byteArray[i] = (byte)(((Byte)HEX_BYTE_MAP.get(Character.valueOf(hi)) << 4) + (Byte)HEX_BYTE_MAP.get(Character.valueOf(lo)));
        }
        return byteArray;
    }

    public static byte[] hexStringToBytes(String message) {
        int len = message.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(message.charAt(i), 16) << 4) + Character.digit(message.charAt(i + 1), 16));
        }
        return data;
    }

    public static String bytes2HexString(byte[] b) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            result.append(String.format("%02X", b[i]));
            result.append(' ');
        }
        return result.toString().trim();
    }

    public static String hexSumString(String str) {
        String[] strings = str.split(" ");
        Integer hexSum = 0;
        for (int i = 0; i < strings.length; ++i) {
            Integer num = Integer.parseInt(strings[i], 16);
            hexSum = hexSum + num;
        }
        String hexSumString = Integer.toHexString(hexSum).toUpperCase();
        if (hexSumString.length() == 3) {
            hexSumString = hexSumString.substring(1);
        }
        return hexSumString;
    }

    static {
        for (int i = 0; i < HEX_CHAR_TABLE.length; ++i) {
            char c = HEX_CHAR_TABLE[i];
            HEX_BYTE_MAP.put(Character.valueOf(c), (byte)i);
        }
    }
}

