/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.shuxi.util.HttpUtil;
import com.shuxi.util.JsonUtil;
import com.shuxi.util.ServletUtil;
import com.shuxi.util.StringUtil;
import com.shuxi.util.XSSEscape;
import com.shuxi.util.context.SpringContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static PoolingHttpClientConnectionManager connectionManager = null;
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(3000).build();

    private HttpUtil() {
        throw new IllegalAccessError("\u5de5\u5177\u7c7b\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static CloseableHttpClient getHttpClient() {
        return HttpUtil.getHttpClientBuilder().build();
    }

    public static CloseableHttpClient getHttpClient(SSLContext sslContext) {
        return HttpUtil.getHttpClientBuilder((SSLContext)sslContext).build();
    }

    public static HttpClientBuilder getHttpClientBuilder() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
    }

    public static HttpClientBuilder getHttpClientBuilder(SSLContext sslContext) {
        if (sslContext != null) {
            return HttpUtil.getHttpClientBuilder().setSSLContext(sslContext);
        }
        return HttpUtil.getHttpClientBuilder();
    }

    public static String sendHttpPost(String httpUrl, SSLContext sslContext) {
        HttpPost httpPost = new HttpPost(httpUrl);
        return HttpUtil.sendHttpPost((HttpPost)httpPost, (SSLContext)sslContext);
    }

    public static String sendHttpPost(String httpUrl) {
        HttpPost httpPost = new HttpPost(httpUrl);
        return HttpUtil.sendHttpPost((HttpPost)httpPost, null);
    }

    public static String sendHttpPost(String httpUrl, String params) {
        return HttpUtil.sendHttpPost((String)httpUrl, (String)params, null);
    }

    public static String sendHttpPost(String httpUrl, String params, SSLContext sslContext) {
        HttpPost httpPost = new HttpPost(httpUrl);
        try {
            StringEntity stringEntity = new StringEntity(params, "UTF-8");
            stringEntity.setContentType("application/x-www-form-urlencoded");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return HttpUtil.sendHttpPost((HttpPost)httpPost, (SSLContext)sslContext);
    }

    public static String sendHttpPost(String httpUrl, Map<String, String> maps) {
        return HttpUtil.sendHttpPost((String)httpUrl, maps, null);
    }

    public static String sendHttpPost(String httpUrl, Map<String, String> maps, SSLContext sslContext) {
        HttpPost httpPost = HttpUtil.wrapHttpPost((String)httpUrl, maps);
        return HttpUtil.sendHttpPost((HttpPost)httpPost, null);
    }

    public static HttpPost wrapHttpPost(String httpUrl, Map<String, String> maps) {
        HttpPost httpPost = new HttpPost(httpUrl);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> m : maps.entrySet()) {
            nameValuePairs.add(new BasicNameValuePair(m.getKey(), m.getValue()));
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return httpPost;
    }

    public static String sendHttpPost(String httpUrl, File file) {
        return HttpUtil.sendHttpPost((String)httpUrl, (Map)ImmutableMap.of((Object)"media", (Object)file), null, null);
    }

    public static String sendHttpPost(String httpUrl, File file, Map<String, String> maps) {
        return HttpUtil.sendHttpPost((String)httpUrl, (Map)ImmutableMap.of((Object)"media", (Object)file), maps, null);
    }

    public static String sendHttpPost(String httpUrl, List<File> fileLists, Map<String, String> maps) {
        return HttpUtil.sendHttpPost((String)httpUrl, fileLists, maps, null);
    }

    public static String sendHttpPost(String httpUrl, Map<String, File> fileMap, Map<String, String> maps) {
        return HttpUtil.sendHttpPost((String)httpUrl, fileMap, maps, null);
    }

    public static String sendHttpPost(String httpUrl, List<File> fileLists, Map<String, String> maps, SSLContext sslContext) {
        HashMap<String, File> fileMap = new HashMap<String, File>(16);
        if (fileLists != null && !fileLists.isEmpty()) {
            for (File file : fileLists) {
                fileMap.put("media", file);
            }
        }
        return HttpUtil.sendHttpPost((String)httpUrl, fileMap, maps, (SSLContext)sslContext);
    }

    public static String sendHttpPost(String httpUrl, Map<String, File> fileMap, Map<String, String> maps, SSLContext sslContext) {
        HttpPost httpPost = new HttpPost(httpUrl);
        MultipartEntityBuilder meBuilder = MultipartEntityBuilder.create();
        if (null != maps) {
            for (Map.Entry<String, Object> entry : maps.entrySet()) {
                meBuilder.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue(), ContentType.TEXT_PLAIN));
            }
        }
        if (null != fileMap) {
            for (Map.Entry<String, Object> entry : fileMap.entrySet()) {
                FileBody fileBody = new FileBody((File)entry.getValue());
                meBuilder.addPart(entry.getKey(), (ContentBody)fileBody);
            }
        }
        HttpEntity reqEntity = meBuilder.build();
        httpPost.setEntity(reqEntity);
        return HttpUtil.sendHttpPost((HttpPost)httpPost, (SSLContext)sslContext);
    }

    public static String sendHttpPost(HttpPost httpPost) {
        return HttpUtil.sendHttpPost((HttpPost)httpPost, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpPost(HttpPost httpPost, SSLContext sslConext) {
        CloseableHttpClient httpClient = HttpUtil.getHttpClient((SSLContext)sslConext);
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (entity != null) {
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return responseContent;
    }

    public static String sendHttpGet(String httpUrl) {
        return HttpUtil.sendHttpGet((String)httpUrl, null);
    }

    public static String sendHttpGet(String httpUrl, SSLContext sslConext) {
        HttpGet httpGet = new HttpGet(httpUrl);
        return HttpUtil.sendHttpGet((HttpGet)httpGet, (SSLContext)sslConext);
    }

    public static String sendHttpGet(HttpGet httpGet) {
        return HttpUtil.sendHttpGet((HttpGet)httpGet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpGet(HttpGet httpGet, SSLContext sslConext) {
        CloseableHttpClient httpClient = HttpUtil.getHttpClient((SSLContext)sslConext);
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (entity != null) {
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return responseContent;
    }

    public static boolean isWxError(JSONObject jsonObject) {
        return null == jsonObject || jsonObject.getIntValue("errcode") != 0;
    }

    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        return HttpUtil.httpRequest((String)requestUrl, (String)requestMethod, (String)outputStr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr, String ... token) {
        JSONObject jsonObject = null;
        try {
            String agent;
            URL url = new URL(requestUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(requestMethod);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(6000);
            conn.setRequestProperty("Content-Type", "application/json");
            if (StringUtil.isNotEmpty((Object[])token)) {
                conn.setRequestProperty("Authorization", XSSEscape.escape((String)token[0]));
                if (token.length > 1 && StringUtil.isNotEmpty((String)token[1])) {
                    Map requestHeader = JsonUtil.stringToMap((String)token[1]);
                    for (String field : requestHeader.keySet()) {
                        conn.setRequestProperty(field, requestHeader.get(field) + "");
                    }
                }
            }
            if (StringUtil.isNotEmpty((String)(agent = ServletUtil.getUserAgent()))) {
                conn.setRequestProperty("User-Agent", agent);
            }
            if (StringUtil.isNotEmpty((String)outputStr)) {
                OutputStream outputStream = conn.getOutputStream();
                try {
                    outputStream.write(outputStr.getBytes("UTF-8"));
                    outputStream.close();
                }
                finally {
                    if (Collections.singletonList(outputStream).get(0) != null) {
                        outputStream.close();
                    }
                }
            }
            InputStream inputStream = conn.getInputStream();
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                try {
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    try {
                        String str = null;
                        StringBuilder buffer = new StringBuilder();
                        while ((str = bufferedReader.readLine()) != null) {
                            buffer.append(str);
                        }
                        bufferedReader.close();
                        inputStreamReader.close();
                        inputStream.close();
                        conn.disconnect();
                        jsonObject = JSONObject.parseObject((String)buffer.toString());
                    }
                    finally {
                        if (Collections.singletonList(bufferedReader).get(0) != null) {
                            bufferedReader.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(inputStreamReader).get(0) != null) {
                        inputStreamReader.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return jsonObject;
    }

    public static void main(String[] args) throws Exception {
        JSONObject param = new JSONObject();
        boolean get = HttpUtil.httpCronRequest((String)"http://192.168.20.128:30000/api/scheduletask", (String)"GET", null, (String)"bearer eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX25hbWUiOiJhZG1pbiIsInNjb3BlIjpbImFsbCJdLCJzaW5nbGVMb2dpbiI6IjEiLCJleHAiOjE2NDY4MzU2MTEsImp0aSI6ImQ2MTVhZDEyLWI0NmItNDgwOC04YmI2LWNhZTY2Y2QyZDVhYSIsImNsaWVudF9pZCI6ImFkbWluIiwidG9rZW4iOiJsb2dpbl90b2tlbl8yNzExODY5NTgxMTIyNjExMjUifQ.E-sPzi1dFoNh-q-cVHn3jti6cxDm1y2fiH8UVYtAYcsoFwZSvx6oubkUefB7xkE9VhCh_syGLbuYhZvRrUAtY-YfH0GG_sNIQXXrzjjieEtpynyBeCGjjZ2U46InjJhOXDMW9FMQS1VSuIx_Z5FuKV93M7kZcAO4ZxhxYcG1_3R4zscxx2hed8ChQvVWf8nbcnuZBUYffan26Y4Fecvi6b0yGrQE_Tmu1D0TjBnsJ5SugRcA_9IxDHIA2H8NfI4tVmeWMVqvNomjBzJaxWZkuXsA-CTzGUvaz9wpRfskh6qTrpnnNpc5p7KsCfkV_Se6KCvfnmD4eNJ27zRvHg1WJA");
        System.out.println(get);
    }

    public static boolean httpCronRequest(String requestUrl, String requestMethod, String outputStr, String token) {
        boolean falg = false;
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection[] conn = new HttpURLConnection[]{null};
            1 task = new /* Unavailable Anonymous Inner Class!! */;
            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)SpringContext.getBean(ThreadPoolTaskExecutor.class);
            Future future = executor.submit((Callable)task);
            try {
                String rst = (String)future.get(3L, TimeUnit.SECONDS);
                if ("url\u8fde\u63a5ok".equals(rst)) {
                    falg = true;
                }
            }
            catch (TimeoutException e) {
                log.error("\u8fde\u63a5url\u8d85\u65f6");
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5f02\u5e38," + e.getMessage());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return falg;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static {
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setMaxTotal(1000);
        connectionManager.setDefaultMaxPerRoute(200);
    }
}

