/*
 * Decompiled with CFR 0.152.
 */
package com.farm.config;

import com.farm.config.HttpConfig;
import com.farm.config.annotate.Pass;
import com.farm.util.SpringUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class ExcludeUrlProperties
implements InitializingBean {
    private static final Pattern PATTERN = Pattern.compile("\\{(.*?)\\}");
    @Value(value="${spring.mvc.servlet.path}")
    private String applicationName;

    public void afterPropertiesSet() {
        String asterisk = "*";
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)SpringUtils.getBean((String)"requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map map = mapping.getHandlerMethods();
        map.keySet().forEach(info -> {
            HandlerMethod handlerMethod = (HandlerMethod)map.get(info);
            Pass method = (Pass)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), Pass.class);
            Optional.ofNullable(method).ifPresent(anonymous -> {
                Set patterns = info.getPatternsCondition().getPatterns();
                patterns.forEach(url -> HttpConfig.LIST.add(this.applicationName + url));
            });
            Pass controller = (Pass)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), Pass.class);
            Optional.ofNullable(controller).ifPresent(anonymous -> {
                Set patterns = info.getPatternsCondition().getPatterns();
                patterns.forEach(url -> HttpConfig.LIST.add(this.applicationName + url));
            });
        });
    }
}

