/*
 * Decompiled with CFR 0.152.
 */
package com.farm.config;

import com.farm.config.RedisConfig;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class RedisConfiguration {
    @Autowired
    private RedisConfig redisConfig;

    @Bean
    public StringRedisSerializer stringRedisSerializer() {
        return new StringRedisSerializer();
    }

    public GenericObjectPoolConfig genericObjectPoolConfig() {
        GenericObjectPoolConfig gopc = new GenericObjectPoolConfig();
        gopc.setMaxIdle(300);
        gopc.setMinIdle(10);
        gopc.setMaxTotal(200);
        gopc.setTestWhileIdle(true);
        gopc.setTestOnBorrow(true);
        gopc.setTestOnReturn(true);
        gopc.setMinEvictableIdleTimeMillis(300000L);
        gopc.setTimeBetweenEvictionRunsMillis(60000L);
        return gopc;
    }

    @Bean(name={"redisTemplate9"})
    public StringRedisTemplate getRedisTemplate9() {
        StringRedisTemplate redisTemplate9 = new StringRedisTemplate();
        RedisStandaloneConfiguration connConfig = new RedisStandaloneConfiguration();
        connConfig.setHostName(this.redisConfig.getIp());
        connConfig.setPort(this.redisConfig.getPort());
        connConfig.setPassword(this.redisConfig.getPsw());
        connConfig.setDatabase(9);
        JedisClientConfiguration jedisClient = JedisClientConfiguration.builder().usePooling().poolConfig(this.genericObjectPoolConfig()).build();
        JedisConnectionFactory factory = new JedisConnectionFactory(connConfig, jedisClient);
        redisTemplate9.setConnectionFactory((RedisConnectionFactory)factory);
        redisTemplate9.setValueSerializer((RedisSerializer)this.stringRedisSerializer());
        redisTemplate9.afterPropertiesSet();
        return redisTemplate9;
    }

    @Bean(name={"redisTemplate6"})
    public StringRedisTemplate getRedisTemplate6() {
        StringRedisTemplate redisTemplate6 = new StringRedisTemplate();
        RedisStandaloneConfiguration connConfig = new RedisStandaloneConfiguration();
        connConfig.setHostName(this.redisConfig.getIp());
        connConfig.setPort(this.redisConfig.getPort());
        connConfig.setPassword(this.redisConfig.getPsw());
        connConfig.setDatabase(6);
        JedisClientConfiguration jedisClient = JedisClientConfiguration.builder().usePooling().poolConfig(this.genericObjectPoolConfig()).and().readTimeout(Duration.ofMillis(1000L)).connectTimeout(Duration.ofMillis(1000L)).build();
        JedisConnectionFactory factory = new JedisConnectionFactory(connConfig, jedisClient);
        redisTemplate6.setConnectionFactory((RedisConnectionFactory)factory);
        redisTemplate6.setValueSerializer((RedisSerializer)this.stringRedisSerializer());
        redisTemplate6.afterPropertiesSet();
        return redisTemplate6;
    }

    @Bean(name={"redisTemplate10"})
    public StringRedisTemplate getRedisTemplate10() {
        StringRedisTemplate redisTemplate6 = new StringRedisTemplate();
        RedisStandaloneConfiguration connConfig = new RedisStandaloneConfiguration();
        connConfig.setHostName(this.redisConfig.getIp());
        connConfig.setPort(this.redisConfig.getPort());
        connConfig.setPassword(this.redisConfig.getPsw());
        connConfig.setDatabase(10);
        JedisClientConfiguration jedisClient = JedisClientConfiguration.builder().usePooling().poolConfig(this.genericObjectPoolConfig()).and().readTimeout(Duration.ofMillis(1000L)).connectTimeout(Duration.ofMillis(1000L)).build();
        JedisConnectionFactory factory = new JedisConnectionFactory(connConfig, jedisClient);
        redisTemplate6.setConnectionFactory((RedisConnectionFactory)factory);
        redisTemplate6.setValueSerializer((RedisSerializer)this.stringRedisSerializer());
        redisTemplate6.afterPropertiesSet();
        return redisTemplate6;
    }

    @Bean(name={"redisTemplate8"})
    public StringRedisTemplate getRedisTemplate8() {
        RedisStandaloneConfiguration connConfig = new RedisStandaloneConfiguration();
        connConfig.setHostName(this.redisConfig.getIp());
        connConfig.setPort(this.redisConfig.getPort());
        connConfig.setPassword(this.redisConfig.getPsw());
        connConfig.setDatabase(8);
        JedisClientConfiguration jedisClient = JedisClientConfiguration.builder().usePooling().poolConfig(this.genericObjectPoolConfig()).build();
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(connConfig, jedisClient);
        StringRedisTemplate redisTemplate8 = new StringRedisTemplate();
        redisTemplate8.setConnectionFactory((RedisConnectionFactory)jedisConnectionFactory);
        redisTemplate8.setValueSerializer((RedisSerializer)this.stringRedisSerializer());
        redisTemplate8.afterPropertiesSet();
        return redisTemplate8;
    }
}

