/*
 * Decompiled with CFR 0.152.
 */
package com.farm.config;

import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.persistent.FileRecorder;
import com.qiniu.util.Auth;
import java.io.IOException;
import java.nio.file.Paths;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

@org.springframework.context.annotation.Configuration
@ConditionalOnClass(value={Servlet.class, StandardServletMultipartResolver.class, MultipartConfigElement.class})
@ConditionalOnProperty(prefix="spring.http.multipart", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MultipartProperties.class})
public class UploadConfig {
    @Value(value="${qiniu.accessKey}")
    private String accessKey;
    @Value(value="${qiniu.secretKey}")
    private String secretKey;
    @Value(value="${qiniu.bucket}")
    private String bucket;
    private final MultipartProperties multipartProperties;

    @Autowired
    public UploadConfig(MultipartProperties multipartProperties) {
        this.multipartProperties = multipartProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MultipartConfigElement multipartConfigElement() {
        return this.multipartProperties.createMultipartConfig();
    }

    @Bean(name={"multipartResolver"})
    @ConditionalOnMissingBean(value={MultipartResolver.class})
    public StandardServletMultipartResolver multipartResolver() {
        StandardServletMultipartResolver multipartResolver = new StandardServletMultipartResolver();
        multipartResolver.setResolveLazily(this.multipartProperties.isResolveLazily());
        return multipartResolver;
    }

    @Bean
    public Configuration qiniuConfig() {
        Configuration configuration = new Configuration(Region.region0());
        configuration.resumableUploadAPIVersion = Configuration.ResumableUploadAPIVersion.V2;
        configuration.resumableUploadMaxConcurrentTaskCount = 5;
        return configuration;
    }

    @Bean
    public UploadManager uploadManager() {
        String localTempDir = Paths.get("tmp/" + this.bucket, new String[0]).toString();
        FileRecorder fileRecorder = null;
        try {
            fileRecorder = new FileRecorder(localTempDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new UploadManager(this.qiniuConfig(), (Recorder)fileRecorder);
    }

    @Bean
    public Auth auth() {
        return Auth.create((String)this.accessKey, (String)this.secretKey);
    }

    @Bean
    public BucketManager bucketManager() {
        return new BucketManager(this.auth(), this.qiniuConfig());
    }
}

