/*
 * Decompiled with CFR 0.152.
 */
package com.farm.config.aspect;

import com.farm.config.HttpConfig;
import com.farm.exception.ModelException;
import com.farm.util.RedisUtil;
import com.farm.util.ResultVo;
import java.lang.reflect.UndeclaredThrowableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RequestAspect {
    private static Logger log = LogManager.getLogger(RequestAspect.class);
    @Autowired
    private RedisUtil redisUtil;
    private static final String token = "f55c9339-203f-4f96-b702-99c5e7977bb3";

    @Pointcut(value="execution(public * com.farm.controller..*.*(..))")
    public void log() {
    }

    @Before(value="log()")
    public void doBefore(JoinPoint joinPoint) {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = sra.getRequest();
        log.info("\u8bf7\u6c42\u8def\u5f84:" + request.getRequestURI());
        log.info("\u8bf7\u6c42IP:" + request.getRemoteHost());
        log.info("\u8bf7\u6c42\u65b9\u5f0f:" + request.getMethod());
        log.info("\u6267\u884c\u65b9\u6cd5:" + joinPoint.getSignature().getDeclaringTypeName() + "." + joinPoint.getSignature().getName());
        Object[] objs = joinPoint.getArgs();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] instanceof HttpServletRequest) {
                objs[i] = "request";
            }
            if (!(objs[i] instanceof HttpServletResponse)) continue;
            objs[i] = "response";
        }
        if (!HttpConfig.NOLOGLIST.contains(request.getRequestURI().replace("//", "/"))) {
            log.info("\u8bf7\u6c42\u53c2\u6570:" + JSONArray.fromObject((Object)objs));
        }
    }

    @Around(value="log()")
    public ResultVo doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        ResultVo result;
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = sra.getRequest();
        String token = request.getHeader("token");
        HttpServletResponse response = sra.getResponse();
        log.error(request.getRequestURI());
        try {
            if (StringUtils.isBlank((String)token) && !HttpConfig.LIST.contains(request.getRequestURI().replace("//", "/"))) {
                response.setStatus(401);
                result = ResultVo.errorAuth();
            } else if (!HttpConfig.LIST.contains(request.getRequestURI().replace("//", "/")) && !token.equals(token)) {
                response.setStatus(401);
                result = ResultVo.errorAuth();
            } else {
                Object proceed = joinPoint.proceed();
                result = proceed instanceof ResultVo ? (ResultVo)proceed : ResultVo.error();
            }
        }
        catch (Throwable e) {
            if (e instanceof ModelException || e instanceof UndeclaredThrowableException && ((UndeclaredThrowableException)e).getUndeclaredThrowable() instanceof ModelException) {
                throw e;
            }
            result = ResultVo.error();
            log.error("\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
        return result == null ? ResultVo.error((String)"") : result;
    }

    @AfterReturning(returning="result", pointcut="log()")
    public void doAfterReturning(Object result) {
        int logMaxLength = 4096;
    }
}

