/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.farm.bean.AdopterCard;
import com.farm.bean.bo.AdopterCardBo;
import com.farm.config.annotate.Pass;
import com.farm.service.AdopterCardService;
import com.farm.util.ResultVo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adopterCard"})
public class AdopterCardController {
    private static final Logger log = LoggerFactory.getLogger(AdopterCardController.class);
    private final AdopterCardService adopterCardService;

    @GetMapping(value={"/listField"})
    public ResultVo listField(String search, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="50") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.adopterCardService.listFieldSpecification(search, start, pageSize));
    }

    @PostMapping(value={"/generateCard"})
    public ResultVo generateCard(@RequestBody AdopterCardBo cardBo) {
        return ResultVo.success((Object)this.adopterCardService.generateCard(cardBo));
    }

    @GetMapping(value={"/list"})
    public ResultVo listCard(AdopterCard card, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.adopterCardService.listCard(card, start, pageSize));
    }

    @PostMapping(value={"/repealCard"})
    public ResultVo redeemCard(Integer id) {
        AdopterCard card = new AdopterCard();
        card.setId(id);
        card.setState(Integer.valueOf(3));
        this.adopterCardService.updateById((Object)card);
        return ResultVo.success((Object)1);
    }

    @GetMapping(value={"/refreshQrUrl"})
    public ResultVo refreshQrUrl() {
        this.adopterCardService.refreshQrUrl();
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    public ResultVo detail(Integer id) {
        return ResultVo.success((Object)this.adopterCardService.getById((Serializable)id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pass
    @GetMapping(value={"/export"})
    public void exportList(AdopterCard card, HttpServletRequest request, HttpServletResponse response) {
        ServletOutputStream out = null;
        InputStream fileInputStream = null;
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        List adopterCardVos = this.adopterCardService.listAllData(card);
        try {
            out = response.getOutputStream();
            response.setContentType("mutipart/form-data;charset=utf-8");
            response.setCharacterEncoding("utf-8");
            LocalDateTime now = LocalDateTime.now();
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode("\u8ba4\u517b\u5361\u6570\u636e\u5bfc\u51fa.xlsx", "UTF-8"));
            fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("model/card.xlsx");
            bos = new ByteArrayOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(fileInputStream);
            workbook.write((OutputStream)bos);
            byte[] bArray = bos.toByteArray();
            is = new ByteArrayInputStream(bArray);
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)out).withTemplate(is).build().fill((Object)adopterCardVos, writeSheet);
            excelWriter.finish();
            out.flush();
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5bfc\u51fa\u9519\u8bef");
            e.printStackTrace();
        }
        finally {
            try {
                fileInputStream.close();
                is.close();
                bos.close();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public AdopterCardController(AdopterCardService adopterCardService) {
        this.adopterCardService = adopterCardService;
    }
}

