/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.farm.bean.Certificate;
import com.farm.service.CertificateService;
import com.farm.util.ResultVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/certificate"})
public class CertificateController {
    private static final Logger log = LoggerFactory.getLogger(CertificateController.class);
    private final CertificateService certificateService;

    @GetMapping(value={"/getStatInfo"})
    public ResultVo getStatInfo(@RequestParam(value="userId") String userId) {
        return ResultVo.success((Object)this.certificateService.queryStatInfo(userId));
    }

    @GetMapping(value={"/getCertificateTypeStat"})
    public ResultVo getCertificateTypeStat(@RequestParam(value="userId") String userId) {
        return ResultVo.success((Object)this.certificateService.queryCertificateTypeStat(userId));
    }

    @PostMapping(value={"/upset"})
    public ResultVo upset(@RequestBody Certificate certificate) {
        return ResultVo.success((Object)this.certificateService.upset(certificate));
    }

    @GetMapping(value={"/list"})
    public ResultVo list(Certificate certificate, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.certificateService.queryPageList(certificate, page, pageSize));
    }

    public CertificateController(CertificateService certificateService) {
        this.certificateService = certificateService;
    }
}

