/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.farm.bean.FieldVideo;
import com.farm.bean.bo.DpDataBo;
import com.farm.config.annotate.Pass;
import com.farm.service.DpDataService;
import com.farm.service.FieldVideoService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ParamAESUtil;
import com.farm.util.ResultVo;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dp/data"})
public class DpDataController {
    @Resource
    private DpDataService dpDataService;
    @Value(value="${farm.serverUrl}")
    private String url;
    @Resource
    private FieldVideoService fieldVideoService;

    @PostMapping(value={"/saveData"})
    @Pass
    public ResultVo saveData(@RequestBody DpDataBo dpData) {
        return ResultVo.success((Object)this.dpDataService.saveData(dpData));
    }

    @GetMapping(value={"/queryDataByTypeCode"})
    @Pass
    public ResultVo queryDataByTypeCode(@RequestParam(value="typeCode") Integer typeCode, @RequestParam(value="businessId", required=false, defaultValue="") String businessId, @RequestParam(value="type", defaultValue="0", required=false) Integer type, @RequestParam(value="title", required=false, defaultValue="") String title, @RequestParam(value="sort", required=false) Integer sort, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="year", required=false, defaultValue="") String year, @RequestParam(value="pageNum", required=false) Integer pageNum, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return ResultVo.success((Object)this.dpDataService.queryDataByTypeCode(typeCode, businessId, type, title, sort, startTime, endTime, year, pageNum, pageSize));
    }

    @PostMapping(value={"/delData"})
    @Pass
    public ResultVo delData(@RequestParam(value="uuids") String uuids) {
        return ResultVo.success((Object)this.dpDataService.delData(uuids));
    }

    @Pass
    @GetMapping(value={"/getFieldInfo"})
    public ResultVo getFieldInfo(@RequestParam(value="fieldId") String fieldId) {
        String fid = ParamAESUtil.dealStr((String)fieldId, (int)2);
        JSONObject result = new JSONObject();
        try {
            String data = HttpSendUtil.sendHttpGet((String)(this.url + "field/getFieldInfo?fieldId=" + fieldId + "&hash=x"));
            result = JSONObject.parseObject((String)data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FieldVideo one = (FieldVideo)this.fieldVideoService.getOne((Wrapper)new LambdaQueryWrapper().eq(FieldVideo::getFieldId, (Object)fid));
        if (one != null && result.containsKey((Object)"resData")) {
            result.getJSONObject("resData").put("videoUrl", (Object)one.getVideoUrl());
            return ResultVo.success((Object)result.getJSONObject("resData"));
        }
        result.getJSONObject("resData").put("videoUrl", (Object)"");
        return ResultVo.success((Object)result.getJSONObject("resData"));
    }
}

