/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.Field;
import com.farm.service.FieldService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ParamAESUtil;
import com.farm.util.ResultVo;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/field"})
public class FieldController {
    private static final Logger log = LoggerFactory.getLogger(FieldController.class);
    private final FieldService fieldService;
    @Value(value="${farm.serverUrl}")
    private String serverUrl;
    @Value(value="${farmServer.userId}")
    private String userId;
    @Value(value="${farmServer.companyId}")
    private String companyId;

    @PostMapping(value={"/upsetField"})
    public ResultVo upsetField(@RequestBody Field field) {
        Boolean existGoods = true;
        if (!existGoods.booleanValue() && field.getId() == null) {
            return ResultVo.error((String)"\u5173\u8054\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        this.fieldService.upset(field);
        return ResultVo.success();
    }

    @GetMapping(value={"/list"})
    public ResultVo listField(Field field, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        JSONObject data = this.fieldService.listField(field, page, pageSize);
        return ResultVo.success((Object)data);
    }

    @GetMapping(value={"/delete"})
    public ResultVo deleteFieldById(@RequestParam(value="id") Integer id) {
        Field field = new Field();
        field.setId(id);
        field.setDelFlag("1");
        this.fieldService.updateById((Object)field);
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    public ResultVo queryFieldDetail(@RequestParam(value="id") Integer id) {
        Field byId = (Field)this.fieldService.getById((Serializable)id);
        if (StringUtils.isNotBlank((String)byId.getRelFieldId())) {
            String result = null;
            try {
                result = HttpSendUtil.sendHttpGet((String)(this.serverUrl + "field/getFieldInfoByFieldId?hash=x&fieldId=" + byId.getRelFieldId()));
                String fieldName = JSONObject.parseObject((String)result).getJSONObject("resData").getString("FIELD_NAME");
                byId.setRelFieldName(fieldName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ResultVo.success((Object)byId);
    }

    @GetMapping(value={"/listCamera"})
    public ResultVo listCamera(@RequestParam(value="userId") String userId, @RequestParam(value="companyId") String companyId, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        try {
            String result = HttpSendUtil.sendHttpGet((String)(this.serverUrl + "wlCustomerDevice/list?deviceNo=&deviceName=&deviceType=19&deviceBrand=&deviceStatus=&fieldIds=&page=" + page + "&pageSize=" + pageSize + "&companyId=" + companyId + "&userId=" + ParamAESUtil.dealStr((String)userId, (int)2)));
            return ResultVo.success((Object)JSONObject.parseObject((String)result).getJSONObject("resData"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultVo.success();
        }
    }

    @GetMapping(value={"/platformDetail"})
    public ResultVo platformDetail(@RequestParam(value="platformId") Integer platformId) {
        try {
            String result = HttpSendUtil.sendHttpGet((String)(this.serverUrl + "wlCustomerDevice/platformDetail?platformId=" + platformId + "&companyId=" + this.companyId + "&userId=" + ParamAESUtil.dealStr((String)this.userId, (int)2)));
            return ResultVo.success((Object)JSONObject.parseObject((String)result).getJSONObject("resData"));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return ResultVo.success();
        }
    }

    @GetMapping(value={"/getInfo"})
    public ResultVo getInfo(Field field) {
        return ResultVo.success((Object)this.fieldService.getInfo(field));
    }

    public FieldController(FieldService fieldService) {
        this.fieldService = fieldService;
    }
}

