/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.farm.bean.Maintenance;
import com.farm.service.MaintenanceService;
import com.farm.util.ResultVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/maintenance"})
public class MaintenanceController {
    private static final Logger log = LoggerFactory.getLogger(MaintenanceController.class);
    private final MaintenanceService maintenanceService;

    @PostMapping(value={"/save"})
    public ResultVo insertMaintenance(@RequestBody Maintenance maintenance) {
        return ResultVo.success((Object)this.maintenanceService.saveMaintenance(maintenance));
    }

    @GetMapping(value={"/list"})
    public ResultVo listMaintenanceData(Maintenance maintenance, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject data = this.maintenanceService.listMaintenance(maintenance, start, pageSize);
        return ResultVo.success((Object)data);
    }

    @PostMapping(value={"/complete"})
    public ResultVo batchComplete(@RequestBody String body) {
        List ids = JSONObject.parseObject((String)body).getJSONArray("ids").toJavaList(String.class);
        this.maintenanceService.batchComplete(ids);
        return ResultVo.success();
    }

    @GetMapping(value={"/delete"})
    public ResultVo deleteById(@RequestParam(value="ids") List<Integer> ids) {
        UpdateWrapper maintenanceUpdateWrapper = new UpdateWrapper();
        maintenanceUpdateWrapper.in((Object)"id", ids);
        maintenanceUpdateWrapper.set((Object)"del_flag", (Object)1);
        return ResultVo.success((Object)this.maintenanceService.update((Wrapper)maintenanceUpdateWrapper));
    }

    public MaintenanceController(MaintenanceService maintenanceService) {
        this.maintenanceService = maintenanceService;
    }
}

