/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.farm.bean.MaintenancePlan;
import com.farm.service.MaintenancePlanService;
import com.farm.task.MaintenancePlanTask;
import com.farm.util.ResultVo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/maintenancePlan"})
public class MaintenancePlanController {
    private static final Logger log = LoggerFactory.getLogger(MaintenancePlanController.class);
    private final MaintenancePlanService maintenancePlanService;
    private final MaintenancePlanTask planTask;

    @PostMapping(value={"/save"})
    public ResultVo savePlan(@RequestBody MaintenancePlan plan) {
        return ResultVo.success((Object)this.maintenancePlanService.savePlan(plan));
    }

    @GetMapping(value={"/list"})
    public ResultVo listPlan(MaintenancePlan plan, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.maintenancePlanService.listPlan(plan, start, pageSize));
    }

    @PostMapping(value={"/changeState"})
    public ResultVo changeState(@RequestBody String body) {
        JSONObject data = JSONObject.parseObject((String)body);
        List ids = data.getJSONArray("ids").toJavaList(Integer.class);
        int state = data.getIntValue("state");
        UpdateWrapper update = new UpdateWrapper();
        update.set((Object)"state", (Object)state);
        update.in((Object)"id", (Collection)ids);
        this.maintenancePlanService.update((Wrapper)update);
        return ResultVo.success();
    }

    @GetMapping(value={"/delete"})
    public ResultVo deleteByIds(@RequestParam(value="ids") List<Integer> ids) {
        UpdateWrapper update = new UpdateWrapper();
        update.set((Object)"del_flag", (Object)1);
        update.in((Object)"id", ids);
        this.maintenancePlanService.update((Wrapper)update);
        return ResultVo.success();
    }

    @GetMapping(value={"/generatePlan"})
    public ResultVo generatePlan() {
        this.planTask.planTask();
        return ResultVo.success();
    }

    public MaintenancePlanController(MaintenancePlanService maintenancePlanService, MaintenancePlanTask planTask) {
        this.maintenancePlanService = maintenancePlanService;
        this.planTask = planTask;
    }
}

