/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.farm.bean.AppProduct;
import com.farm.bean.AppSpecification;
import com.farm.bean.Field;
import com.farm.config.annotate.Pass;
import com.farm.mapper.AdopterCardMapper;
import com.farm.service.AppProductService;
import com.farm.service.AppSpecificationService;
import com.farm.service.FieldService;
import com.farm.util.ResultVo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/map"})
public class MapController {
    private static final Logger log = LoggerFactory.getLogger(MapController.class);
    private final FieldService fieldService;
    private final AppSpecificationService appSpecificationService;
    private final AppProductService appProductService;
    private final AdopterCardMapper adopterCardMapper;

    @GetMapping(value={"/queryProductByMapId"})
    @Pass
    public ResultVo queryProductByMapId(@RequestParam(value="mapNo") String mapNo) {
        ArrayList goodsList = new ArrayList();
        List fieldList = this.fieldService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Field::getMapNo, (Object)mapNo)).isNotNull(Field::getGoodsId));
        fieldList.forEach(f -> goodsList.add(f.getGoodsId()));
        AppProduct product = new AppProduct();
        if (goodsList.size() > 0) {
            product = (AppProduct)this.appProductService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AppProduct::getId, (Object)((Field)fieldList.get(0)).getGoodsId())).eq(AppProduct::getStatus, (Object)2));
            product.setFieldId(((Field)fieldList.get(0)).getId());
            product.setFieldName(((Field)fieldList.get(0)).getFieldName());
            List goodsData = new ArrayList();
            goodsData = this.appSpecificationService.list((Wrapper)new LambdaQueryWrapper().in(AppSpecification::getProductId, goodsList));
            List goodsDataOrder = this.appSpecificationService.rectifyNum(goodsList, goodsData);
            if (goodsDataOrder != null && goodsDataOrder.size() > 0) {
                goodsData.forEach(item -> {
                    Integer lockCard = this.adopterCardMapper.countLockCard(item.getId());
                    goodsDataOrder.forEach(sItem -> {
                        if (item.getId().intValue() == sItem.getId().intValue()) {
                            item.setNum(Long.valueOf(item.getNum() - sItem.getNum()));
                        }
                    });
                    item.setNum(Long.valueOf(item.getNum() - (long)lockCard.intValue()));
                });
            } else {
                goodsData.forEach(item -> {
                    Integer lockCard = this.adopterCardMapper.countLockCard(item.getId());
                    item.setNum(Long.valueOf(item.getNum() - (long)lockCard.intValue()));
                });
            }
            product.setGoodsList(goodsData);
        }
        return ResultVo.success((Object)product);
    }

    @GetMapping(value={"/queryProductByName"})
    @Pass
    public ResultVo queryProductByName(@RequestParam(value="id", required=false) String id, @RequestParam(value="name", required=false) String name) {
        return ResultVo.success((Object)this.appProductService.queryProductByName(id, name));
    }

    public MapController(FieldService fieldService, AppSpecificationService appSpecificationService, AppProductService appProductService, AdopterCardMapper adopterCardMapper) {
        this.fieldService = fieldService;
        this.appSpecificationService = appSpecificationService;
        this.appProductService = appProductService;
        this.adopterCardMapper = adopterCardMapper;
    }
}

