/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.farm.bean.bo.OrderUserBo;
import com.farm.config.annotate.Pass;
import com.farm.service.OrderVxService;
import com.farm.util.ResultVo;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/order"})
public class OrderVxController {
    @Resource
    private OrderVxService orderVxService;

    @PostMapping(value={"/createOrder"})
    @Pass
    public ResultVo createOrder(@RequestBody OrderUserBo orderBo) {
        return ResultVo.success((Object)this.orderVxService.createOrder(orderBo));
    }

    @GetMapping(value={"/queryOrderList"})
    @Pass
    public ResultVo queryOrderList(@RequestParam(value="status", required=false, defaultValue="-1") Integer status, @RequestParam(value="userId") String userId, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.orderVxService.queryOrderList(status, userId, pageNum, pageSize));
    }

    @GetMapping(value={"/queryOrderDetail"})
    @Pass
    public ResultVo queryOrderDetail(@RequestParam(value="orderNum") String orderNum) {
        return ResultVo.success((Object)this.orderVxService.queryOrderDetail(orderNum));
    }

    @GetMapping(value={"/myRecord"})
    @Pass
    public ResultVo getmyRecordList(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.orderVxService.queryOrderRecordList(userId, page, pageSize));
    }

    @PostMapping(value={"/cancelOrder"})
    @Pass
    public ResultVo cancelOrder(@RequestParam(value="orderNum") String orderNum) {
        return ResultVo.success((Object)this.orderVxService.cancelOrder(orderNum));
    }

    @PostMapping(value={"/delOrder"})
    @Pass
    public ResultVo delOrder(@RequestParam(value="orderNum") String orderNum) {
        return ResultVo.success((Object)this.orderVxService.delOrder(orderNum));
    }

    @PostMapping(value={"/confirmReceipt"})
    public ResultVo confirmReceipt(@RequestParam(value="orderNum") String orderNum) {
        return ResultVo.success((Object)this.orderVxService.confirmReceipt(orderNum));
    }
}

