/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.farm.bean.bo.AppProductBo;
import com.farm.config.annotate.Pass;
import com.farm.service.AppProductService;
import com.farm.util.ResultVo;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/product"})
public class ProductController {
    @Resource
    private AppProductService appProductService;

    @GetMapping(value={"/web/list"})
    @Pass
    public ResultVo webList(@RequestParam(value="productNumber", required=false, defaultValue="") String productNumber, @RequestParam(value="fieldName", required=false, defaultValue="") String fieldName, @RequestParam(value="status", required=false, defaultValue="") Integer status, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.appProductService.webList(productNumber, fieldName, status, pageNum, pageSize));
    }

    @PostMapping(value={"/saveOrUpdate"})
    @Pass
    public ResultVo saveOrUpdate(@RequestBody AppProductBo appProductBo) {
        return ResultVo.success((Object)this.appProductService.addOrUpdate(appProductBo));
    }

    @GetMapping(value={"/detail"})
    @Pass
    public ResultVo detail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.appProductService.detail(id));
    }

    @PostMapping(value={"/updateStatus"})
    public ResultVo updateStatus(@RequestParam(value="id") Integer id, @RequestParam(value="status") Integer status) {
        return ResultVo.success((Object)this.appProductService.updateStatus(id, status));
    }

    @PostMapping(value={"/delProduct"})
    public ResultVo delProduct(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.appProductService.delProduct(id));
    }
}

