/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.farm.bean.Property;
import com.farm.service.PropertyService;
import com.farm.service.PropertyTypeService;
import com.farm.util.ResultVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/property"})
public class PropertyController {
    private static final Logger log = LoggerFactory.getLogger(PropertyController.class);
    private final PropertyService propertyService;
    private final PropertyTypeService propertyTypeService;

    @PostMapping(value={"/upset"})
    public ResultVo upsetProperty(@RequestBody Property property) {
        this.propertyService.saveOrUpdate((Object)property);
        return ResultVo.success();
    }

    @GetMapping(value={"/list"})
    public ResultVo listPropertyData(Property property, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.propertyService.listProperty(property, start, pageSize));
    }

    @GetMapping(value={"/delete"})
    public ResultVo deleteById(Integer id) {
        Property update = new Property();
        update.setId(id);
        update.setDelFlag(Integer.valueOf(1));
        this.propertyService.updateById((Object)update);
        return ResultVo.success();
    }

    public PropertyController(PropertyService propertyService, PropertyTypeService propertyTypeService) {
        this.propertyService = propertyService;
        this.propertyTypeService = propertyTypeService;
    }
}

