/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.farm.bean.Property;
import com.farm.bean.PropertyType;
import com.farm.service.PropertyService;
import com.farm.service.PropertyTypeService;
import com.farm.util.ResultVo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/propertyType"})
public class PropertyTypeController {
    private static final Logger log = LoggerFactory.getLogger(PropertyTypeController.class);
    private final PropertyTypeService propertyTypeService;
    private final PropertyService propertyService;

    @PostMapping(value={"/upset"})
    public ResultVo upsetType(@RequestBody PropertyType propertyType) {
        this.propertyTypeService.saveOrUpdate((Object)propertyType);
        return ResultVo.success();
    }

    @GetMapping(value={"/delete"})
    public ResultVo deleteTypeById(Integer id) {
        PropertyType update = new PropertyType();
        update.setId(id);
        update.setDelFlag(Integer.valueOf(1));
        this.propertyTypeService.updateById((Object)update);
        return ResultVo.success();
    }

    @GetMapping(value={"/list"})
    public ResultVo listTypeData(PropertyType type, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PropertyType::getDelFlag, (Object)0);
        if (StringUtils.isNotBlank((String)type.getTypeName())) {
            query.like(PropertyType::getTypeName, (Object)type.getTypeName());
        }
        List list = this.propertyTypeService.list((Wrapper)query);
        return ResultVo.success((Object)list);
    }

    @GetMapping(value={"/listAllData"})
    public ResultVo listAllData() {
        List list = this.propertyTypeService.list((Wrapper)new LambdaQueryWrapper().eq(PropertyType::getDelFlag, (Object)0));
        List ids = list.stream().map(l -> l.getId()).collect(Collectors.toList());
        List propertyList = this.propertyService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Property::getDelFlag, (Object)0)).in(Property::getTypeId, ids));
        list.forEach(l -> {
            long count = propertyList.stream().filter(p -> p.getTypeId().equals(l.getId())).count();
            if (count > 0L) {
                l.setPropertyList(propertyList.stream().filter(p -> p.getTypeId().equals(l.getId())).collect(Collectors.toList()));
            } else {
                l.setPropertyList(new ArrayList());
            }
        });
        return ResultVo.success((Object)list);
    }

    public PropertyTypeController(PropertyTypeService propertyTypeService, PropertyService propertyService) {
        this.propertyTypeService = propertyTypeService;
        this.propertyService = propertyService;
    }
}

