/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.farm.bean.ShippingAddress;
import com.farm.service.ShippingAddressService;
import com.farm.util.ResultVo;
import java.util.Arrays;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/shippingAddress"})
public class ShippingAddressController {
    private static final Logger log = LoggerFactory.getLogger(ShippingAddressController.class);
    private final ShippingAddressService shippingAddressService;

    @PostMapping(value={"/upset"})
    public ResultVo upsetFieldLog(@RequestBody ShippingAddress info) {
        return ResultVo.success((Object)this.shippingAddressService.saveAddress(info));
    }

    @GetMapping(value={"/list"})
    public ResultVo list(ShippingAddress info, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.shippingAddressService.queryPageList(info, page, pageSize));
    }

    @GetMapping(value={"/delete"})
    public ResultVo deleteById(@NotEmpty(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String ids) {
        return ResultVo.success((Object)this.shippingAddressService.deleteByIds(Arrays.asList(ids.split(","))));
    }

    @GetMapping(value={"/getMainInfo"})
    public ResultVo getMainInfo(@RequestParam(value="userId") String userId) {
        return ResultVo.success((Object)this.shippingAddressService.queryMainInfo(userId));
    }

    @GetMapping(value={"/getInfo"})
    public ResultVo getInfo(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.shippingAddressService.queryInfo(id));
    }

    public ShippingAddressController(ShippingAddressService shippingAddressService) {
        this.shippingAddressService = shippingAddressService;
    }
}

