/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.farm.config.annotate.Pass;
import com.farm.service.QiNiuService;
import com.farm.util.ResultVo;
import com.qiniu.http.Response;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/upload"})
public class UploadController {
    private static final Logger log = LoggerFactory.getLogger(UploadController.class);
    private final QiNiuService qiNiuService;
    @Value(value="${qiniu.ip}")
    private String addressIp;

    @Pass
    @CrossOrigin
    @PostMapping(value={"/file"})
    public ResultVo uploadFile(@RequestParam(value="file") MultipartFile file) {
        if (file.isEmpty()) {
            return ResultVo.error((String)"1001");
        }
        String originalFilename = file.getOriginalFilename();
        String fileName = UUID.randomUUID().toString().substring(0, 9) + LocalDateTime.now().toEpochSecond(ZoneOffset.ofHours(8)) + originalFilename.substring(originalFilename.indexOf("."));
        try {
            Response response = this.qiNiuService.uploadFile(file.getInputStream(), file.getSize(), fileName);
            if (response.isOK()) {
                JSONObject jsonObject = JSONObject.fromObject((Object)response.bodyString());
                String yunFileName = jsonObject.getString("key");
                String yunFilePath = this.addressIp + yunFileName;
                JSONObject result = new JSONObject();
                result.put((Object)"url", (Object)yunFilePath);
                return ResultVo.success((Object)result);
            }
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)JSONObject.fromObject((Object)response));
            return ResultVo.error((String)"1001");
        }
        catch (IOException e) {
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c\u7edd\u5bf9\u8def\u5f84\uff1a{}", (Object)System.getProperty("user.dir"));
            return ResultVo.error((String)"1001");
        }
    }

    public UploadController(QiNiuService qiNiuService) {
        this.qiNiuService = qiNiuService;
    }
}

