/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.farm.config.annotate.Pass;
import com.farm.service.UserInfoService;
import com.farm.service.WeChatService;
import com.farm.service.WxConfigService;
import com.farm.util.ResultVo;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechat"})
public class WeChatController {
    private static final Logger log = LoggerFactory.getLogger(WeChatController.class);
    @Resource
    private WeChatService weChatService;
    @Resource
    private WxConfigService wxConfigService;
    @Resource
    private UserInfoService userInfoService;

    @GetMapping(value={"/vxConfig"})
    public String vxConfig(HttpServletRequest request) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        return echostr;
    }

    @GetMapping(value={"/accessToken"})
    public ResultVo queryAccessToken(@RequestParam(value="code") String code) {
        return ResultVo.success((Object)this.weChatService.queryAccessToken(code));
    }

    @Pass
    @GetMapping(value={"/phone"})
    public ResultVo queryPhone(@RequestParam(value="loginCode") String loginCode, @RequestParam(value="encryptedData") String encryptedData, @RequestParam(value="iv") String iv) {
        return ResultVo.success((Object)this.weChatService.queryPhone(loginCode, encryptedData, iv));
    }

    @GetMapping(value={"/queryWxSign"})
    public ResultVo queryWxSign(@RequestParam(value="url") String url) {
        return ResultVo.success((Object)this.wxConfigService.queryWxSign(url));
    }

    @Pass
    @PostMapping(value={"/updateUser"})
    public ResultVo updateUser(@RequestBody String body) {
        JSONObject data = JSONObject.parseObject((String)body);
        String openId = data.getString("opendid");
        String avatorWx = data.getString("avatorWx");
        String nickName = data.getString("nickName");
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"wx_open_id", (Object)openId);
        updateWrapper.set((Object)"avator_wx", (Object)avatorWx);
        updateWrapper.set((Object)"nick_name", (Object)nickName);
        this.userInfoService.update((Wrapper)updateWrapper);
        return ResultVo.success();
    }

    @GetMapping(value={"/test"})
    public ResultVo test() {
        return ResultVo.success((Object)"test");
    }
}

