/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.farm.bean.WXPayConfig;
import com.farm.config.annotate.Pass;
import com.farm.service.WeChatPayService;
import com.farm.util.PayUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/weChatPay"})
public class WeChatPayController {
    @Resource
    private WeChatPayService weChatPayService;

    @PostMapping(value={"/orderNotify"})
    @ApiOperation(value="\u652f\u4ed8\u56de\u8c03")
    @Pass
    public void orderNotify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        String notityXml = sb.toString();
        String resXml = "";
        System.out.println("\u63a5\u6536\u5230\u7684\u62a5\u6587\uff1a" + notityXml);
        Map map = PayUtil.doXMLParse((String)notityXml);
        String returnCode = (String)map.get("return_code");
        if ("SUCCESS".equals(returnCode)) {
            Map validParams = PayUtil.paraFilter((Map)map);
            String validStr = PayUtil.createLinkString((Map)validParams);
            String sign = PayUtil.sign((String)validStr, (String)WXPayConfig.paternerKey, (String)"utf-8").toUpperCase();
            if (sign.equals(map.get("sign"))) {
                String out_trade_no = map.get("out_trade_no").toString();
                this.weChatPayService.orderSucceeded(out_trade_no);
                resXml = "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml> ";
            } else {
                System.out.println("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u5931\u8d25!\u7b7e\u540d\u4e0d\u4e00\u81f4");
            }
        } else {
            resXml = "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u62a5\u6587\u4e3a\u7a7a]]></return_msg></xml> ";
        }
        System.out.println(resXml);
        System.out.println("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u6570\u636e\u7ed3\u675f");
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        out.write(resXml.getBytes());
        out.flush();
        out.close();
    }

    @PostMapping(value={"/orderAgainPayment"})
    @ApiOperation(value="\u672a\u652f\u4ed8\u8ba2\u5355\u8c03\u7528\u4ed8\u6b3e")
    @Pass
    public ResultVo orderAgainPayment(@RequestParam(value="userId") String userId, @RequestParam(value="orderNum") String orderNum) {
        return ResultVo.success((Object)this.weChatPayService.orderAgainPayment(userId, orderNum));
    }
}

