/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AdopterCard;
import com.farm.mapper.AdopterCardMapper;
import com.farm.service.QiNiuService;
import com.farm.service.WeChatService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AsyncService {
    @Value(value="${wechat.url}")
    private String wechatUrl;
    @Value(value="${qr.envVersion}")
    private String envVersion;
    @Value(value="${qiniu.ip}")
    private String addressIp;
    private final QiNiuService qiNiuService;
    private final WeChatService weChatService;
    private final AdopterCardMapper adopterCardMapper;

    @Async
    public void generateQrUrl(List<AdopterCard> adopterCards) {
        String token = this.weChatService.queryAccessToken("");
        adopterCards.forEach(a -> {
            AdopterCard card = new AdopterCard();
            StringBuilder str = new StringBuilder(this.wechatUrl);
            str.append("wxa/getwxacodeunlimit?access_token=" + token);
            JSONObject body = new JSONObject();
            body.put("page", (Object)"pages/adoptedCard/index");
            body.put("scene", (Object)a.getId());
            body.put("check_path", (Object)false);
            body.put("env_version", (Object)this.envVersion);
            try {
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                HttpPost httpPost = new HttpPost(str.toString());
                httpPost.addHeader("Content-Type", "application/json");
                httpPost.setEntity((HttpEntity)new StringEntity(body.toJSONString()));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                InputStream ins = response.getEntity().getContent();
                byte[] bytes = IOUtils.toByteArray((InputStream)ins);
                String base64Str = Base64.getEncoder().encodeToString(bytes);
                String fileName = "dfQr/" + UUID.randomUUID().toString() + ".jpeg";
                this.qiNiuService.uploadBase64(base64Str, fileName);
                String qrUrl = this.addressIp + fileName;
                card.setId(a.getId());
                card.setQrUrl(qrUrl);
                card.setQrState("1");
                this.adopterCardMapper.updateById((Object)card);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public AsyncService(QiNiuService qiNiuService, WeChatService weChatService, AdopterCardMapper adopterCardMapper) {
        this.qiNiuService = qiNiuService;
        this.weChatService = weChatService;
        this.adopterCardMapper = adopterCardMapper;
    }
}

