/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.farm.bean.AdopterCard;
import com.farm.bean.AppSpecification;
import com.farm.bean.bo.AdopterCardBo;
import com.farm.bean.vo.AdopterCardExportVo;
import com.farm.exception.ModelException;
import com.farm.mapper.AdopterCardMapper;
import com.farm.mapper.AppSpecificationMapper;
import com.farm.mapper.FieldMapper;
import com.farm.mapper.OrderVxMapper;
import com.farm.service.AdopterCardService;
import com.farm.service.AsyncService;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AdopterCardServiceImpl
extends ServiceImpl<AdopterCardMapper, AdopterCard>
implements AdopterCardService {
    private static final Logger log = LoggerFactory.getLogger(AdopterCardServiceImpl.class);
    private final FieldMapper fieldMapper;
    private final AppSpecificationMapper appSpecificationMapper;
    private final OrderVxMapper orderVxMapper;
    private final AdopterCardMapper adopterCardMapper;
    private static final String LOWERCASE_LETTERS = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPERCASE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGITS = "0123456789";
    private static final String ALLOWED_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private final AsyncService asyncService;

    public JSONObject listFieldSpecification(String search, Integer start, Integer pageSize) {
        JSONObject result = new JSONObject();
        result.put("count", (Object)this.fieldMapper.countFieldSpecification(search));
        List fieldSpecificationVos = this.fieldMapper.listFieldSpecification(search, start, pageSize);
        fieldSpecificationVos.forEach(f -> f.getSpecifications().forEach(s -> {
            Integer lockOrder = this.orderVxMapper.queryOrderSpecificationNum(s.getId());
            Integer lockCard = this.adopterCardMapper.countLockCard(s.getId());
            Integer sum = lockOrder + lockCard;
            s.setNum(Long.valueOf(s.getNum() - (long)sum.intValue()));
        }));
        result.put("list", (Object)fieldSpecificationVos);
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Integer generateCard(AdopterCardBo adopterCardBo) {
        Integer specificationId = adopterCardBo.getSpecificationId();
        Integer lockOrder = this.orderVxMapper.queryOrderSpecificationNum(specificationId);
        Integer lockCard = this.adopterCardMapper.countLockCard(specificationId);
        Integer sum = lockOrder + lockCard;
        Integer generateCount = adopterCardBo.getCount();
        AppSpecification appSpecification = (AppSpecification)this.appSpecificationMapper.selectById((Serializable)specificationId);
        if (appSpecification.getNum() - (long)lockOrder.intValue() - (long)lockCard.intValue() - (long)generateCount.intValue() < 0L) {
            throw new ModelException("\u5546\u54c1\u6570\u91cf\u4e0d\u8db3,\u65e0\u6cd5\u751f\u6210");
        }
        ArrayList<AdopterCard> adopterCardList = new ArrayList<AdopterCard>();
        Integer i = 0;
        while (i < generateCount) {
            AdopterCard adopterCard = new AdopterCard();
            adopterCard.setCardNum(AdopterCardServiceImpl.generateCardNumber((int)(i + 1)));
            adopterCard.setCardPwd(AdopterCardServiceImpl.generateRandomPassword((int)8));
            adopterCard.setFieldId(adopterCardBo.getFieldId());
            adopterCard.setProductId(appSpecification.getProductId());
            adopterCard.setSpecificationId(specificationId);
            adopterCard.setState(Integer.valueOf(0));
            adopterCard.setExpireDate(adopterCardBo.getExpireDate());
            adopterCardList.add(adopterCard);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.saveBatch(adopterCardList);
        this.appSpecificationMapper.updateVersion(specificationId);
        this.asyncService.generateQrUrl(adopterCardList);
        return 1;
    }

    public JSONObject listCard(AdopterCard card, Integer start, Integer pageSize) {
        JSONObject result = new JSONObject();
        result.put("count", (Object)this.adopterCardMapper.countCard(card));
        result.put("list", (Object)this.adopterCardMapper.listCardData(card, start, pageSize));
        return result;
    }

    public List<AdopterCardExportVo> listAllData(AdopterCard card) {
        return this.adopterCardMapper.listExportCardData(card);
    }

    public Integer refreshQrUrl() {
        List adopterCards = this.adopterCardMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(AdopterCard::getQrState, (Object)0));
        this.asyncService.generateQrUrl(adopterCards);
        return 1;
    }

    public Integer refreshCardState() {
        return this.adopterCardMapper.refreshCardState(DateUtil.now());
    }

    public static String generateCardNumber(int sequenceNumber) {
        long timestamp = System.currentTimeMillis();
        Random random = new Random();
        int randomValue = random.nextInt(10000);
        String randomStr = String.format("%04d", randomValue);
        String sequenceNumberStr = String.format("%04d", sequenceNumber);
        String cardNumber = timestamp + randomStr + sequenceNumberStr;
        return cardNumber;
    }

    public static String generateRandomPassword(int length) {
        SecureRandom random = new SecureRandom();
        StringBuilder password = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length());
            char randomChar = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(randomIndex);
            password.append(randomChar);
        }
        return password.toString();
    }

    public AdopterCardServiceImpl(FieldMapper fieldMapper, AppSpecificationMapper appSpecificationMapper, OrderVxMapper orderVxMapper, AdopterCardMapper adopterCardMapper, AsyncService asyncService) {
        this.fieldMapper = fieldMapper;
        this.appSpecificationMapper = appSpecificationMapper;
        this.orderVxMapper = orderVxMapper;
        this.adopterCardMapper = adopterCardMapper;
        this.asyncService = asyncService;
    }
}

