/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.farm.bean.AppProduct;
import com.farm.bean.bo.AppProductBo;
import com.farm.bean.vo.AppProductDetailVo;
import com.farm.mapper.AppProductMapper;
import com.farm.service.AppProductService;
import com.farm.service.AppSpecificationService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppProductServiceImpl
extends ServiceImpl<AppProductMapper, AppProduct>
implements AppProductService {
    @Resource
    private AppSpecificationService appSpecificationService;
    @Resource
    private AppProductService appProductService;

    public JSONObject queryProductByName(String id, String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)2);
        if (name != null) {
            ((QueryWrapper)((QueryWrapper)queryWrapper.like((Object)"product_name", (Object)name)).or()).eq(StringUtils.isNotBlank((String)id), (Object)"id", (Object)id);
        }
        List list = ((AppProductMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public synchronized Integer addOrUpdate(AppProductBo appProductBo) {
        return this.appProductService.addOrUpdateService(appProductBo);
    }

    public Integer addOrUpdateService(AppProductBo appProductBo) {
        AppProduct appProduct = (AppProduct)BeanUtil.toBean((Object)appProductBo, AppProduct.class);
        DateTime date = DateUtil.date();
        String dateStr = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
        Long productNumber = ((AppProductMapper)this.getBaseMapper()).queryDateCount(dateStr);
        List list = appProductBo.getList();
        if (productNumber == null) {
            productNumber = Long.parseLong(dateStr.replace("-", "") + "001");
        } else {
            Long l = productNumber;
            Long l2 = productNumber = Long.valueOf(productNumber + 1L);
        }
        appProduct.setProductNumber(String.valueOf(productNumber));
        if (appProduct.getId() == null) {
            appProduct.setCraeteTime(date.toDateStr());
            appProduct.setUpdateTime(appProduct.getCraeteTime());
            this.save((Object)appProduct);
            this.appSpecificationService.add(appProduct, list);
        } else {
            appProduct.setUpdateTime(date.toDateStr());
            this.appSpecificationService.upd(appProduct, list);
            this.saveOrUpdate((Object)appProduct);
        }
        return 1;
    }

    public JSONObject webList(String productNumber, String fieldName, Integer status, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer start = 0;
        if (pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        List list = ((AppProductMapper)this.getBaseMapper()).queryWebList(productNumber, fieldName, status, start, pageSize);
        Integer count = ((AppProductMapper)this.getBaseMapper()).queryWebListCount(productNumber, fieldName, status);
        list.forEach(item -> {
            Long sum = ((AppProductMapper)this.getBaseMapper()).getLatchingNum(item.getSpecificationIds());
            item.setNum(Long.valueOf(item.getNum() - sum));
        });
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public AppProductDetailVo detail(Integer id) {
        AppProductDetailVo detail = ((AppProductMapper)this.getBaseMapper()).detail(id);
        detail.getList().forEach(item -> {
            Long latchingNum = ((AppProductMapper)this.getBaseMapper()).getLatchingNum(String.valueOf(item.getId()));
            item.setNum(Long.valueOf(item.getNum() - latchingNum));
        });
        return detail;
    }

    public Integer updateStatus(Integer id, Integer status) {
        return ((AppProductMapper)this.getBaseMapper()).updateStatus(id, status);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Integer delProduct(Integer id) {
        ((AppProductMapper)this.baseMapper).delProduct(id);
        return 1;
    }
}

