/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.farm.bean.Certificate;
import com.farm.bean.vo.CertificateStatVo;
import com.farm.bean.vo.CertificateTypeVo;
import com.farm.mapper.CertificateMapper;
import com.farm.service.CertificateService;
import com.farm.util.WatermarkUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CertificateServiceImpl
extends ServiceImpl<CertificateMapper, Certificate>
implements CertificateService {
    private final CertificateMapper baseMapper;

    public CertificateStatVo queryStatInfo(String userId) {
        return this.baseMapper.queryCertificateStat(userId);
    }

    public List<CertificateTypeVo> queryCertificateTypeStat(String userId) {
        return this.baseMapper.queryCertificateTypeStat(userId);
    }

    public boolean upset(Certificate certificate) {
        long start = System.currentTimeMillis();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try {
            if (certificate != null && StringUtils.isNotBlank((CharSequence)certificate.getFieldName()) && StringUtils.isNotBlank((CharSequence)certificate.getSpecificationName()) && certificate.getNum() != null && StringUtils.isNotBlank((CharSequence)certificate.getSpecificationUnit()) && StringUtils.isNotBlank((CharSequence)certificate.getOrderNum())) {
                String fName = "\u5df2\u8ba4\u517b\u3010" + certificate.getFieldName() + "\u3011";
                String sName = certificate.getNum().toString() + certificate.getSpecificationUnit() + certificate.getSpecificationName();
                String time = LocalDate.now().format(df);
                String uuid = UUID.randomUUID().toString();
                String imageUrl = WatermarkUtils.getImageUrl((String)fName, (String)sName, (String)time, (String)uuid.substring(0, 12), (String)certificate.getSpecificationName());
                this.log.error("\u6267\u884c\u65f6\u957f" + (System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                certificate.setUrl(imageUrl);
                certificate.setDate(time);
                certificate.setUuid(uuid);
                boolean b = this.baseMapper.insert((Object)certificate) > 0;
                this.log.error("\u65b0\u589e\u6267\u884c\u65f6\u957f" + (System.currentTimeMillis() - start));
                return b;
            }
        }
        catch (Exception e) {
            this.log.error("\u65b0\u589e\u8ba4\u517b\u51ed\u8bc1\u9519\u8bef\uff1a" + e.getMessage());
        }
        return false;
    }

    public JSONObject queryPageList(Certificate certificate, Integer page, Integer pageSize) {
        JSONObject result = new JSONObject();
        Page pageInfo = new Page((long)page.intValue(), (long)pageSize.intValue());
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(Certificate::getSpecificationName, (Object)certificate.getSpecificationName());
        query.eq(Certificate::getUserId, (Object)certificate.getUserId());
        query.orderByDesc(Certificate::getId);
        Page pageList = (Page)this.baseMapper.selectPage((IPage)pageInfo, (Wrapper)query);
        result.put("list", (Object)pageList.getRecords());
        result.put("count", (Object)pageList.getTotal());
        return result;
    }

    public CertificateServiceImpl(CertificateMapper baseMapper) {
        this.baseMapper = baseMapper;
    }
}

