/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DpData;
import com.farm.bean.bo.DpDataBo;
import com.farm.bean.vo.DpDataVo;
import com.farm.mapper.DpDataMapper;
import com.farm.service.DpDataService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DpDataServiceImpl
implements DpDataService {
    @Resource
    private DpDataMapper dpDataMapper;

    public Integer saveData(DpDataBo dpDataBo) {
        DpData dpData = (DpData)BeanUtil.toBean((Object)dpDataBo, DpData.class);
        if (dpDataBo.getBusinessId() == null) {
            if (dpDataBo.getType() == 0) {
                this.dpDataMapper.saveData(dpData);
            } else {
                String uuid;
                this.dpDataMapper.saveData(dpData);
                if (dpData.getJsonData().getString("uuid") == null || dpData.getJsonData().getString("uuid").isEmpty()) {
                    uuid = IdUtil.simpleUUID();
                    dpData.getJsonData().put("uuid", (Object)uuid);
                } else {
                    uuid = dpData.getJsonData().getString("uuid");
                }
                if (dpData.getId() == null) {
                    dpData.setId(this.dpDataMapper.queryId(dpData.getTypeCode()));
                }
                this.dpDataMapper.saveDataList(uuid, dpData.getId(), JSONObject.toJSONString((Object)dpData.getJsonData()), dpData.getJsonData().getString("title"), dpData.getJsonData().getString("sort"), dpData.getJsonData().getString("time"), dpData.getJsonData().getString("year"));
            }
        } else {
            this.dpDataMapper.saveNodeData(dpData);
        }
        return 1;
    }

    public JSONObject queryDataByTypeCode(Integer typeCode, String businessId, Integer type, String title, Integer sort, String startTime, String endTime, String year, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        if (businessId == null || businessId.isEmpty() && type == 0) {
            json.put("data", (Object)this.dpDataMapper.queryDataByTypeCode(typeCode));
        } else if (type != null) {
            Integer start = null;
            if (pageNum != null && pageSize != null && pageNum != null && pageNum != null) {
                start = (pageNum - 1) * pageSize;
            }
            List data = this.dpDataMapper.queryList(typeCode, title, sort, startTime, endTime, year, start, pageSize);
            if (start != null && pageSize != null) {
                json.put("count", (Object)this.dpDataMapper.queryListCount(typeCode, title, sort, startTime, endTime, year));
            }
            json.put("data", (Object)data);
        } else {
            DpDataVo dpDataVo = this.dpDataMapper.queryDataNodeByBusinessId(typeCode, businessId);
            if (dpDataVo == null) {
                dpDataVo = new DpDataVo();
                JSONObject json1 = new JSONObject();
                json1.put("list", new ArrayList());
                dpDataVo.setDataJson(json);
                json.put("data", (Object)dpDataVo);
            }
        }
        return json;
    }

    public Integer delData(String uuids) {
        return this.dpDataMapper.delData(uuids);
    }
}

