/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.farm.bean.Field;
import com.farm.mapper.FieldMapper;
import com.farm.service.FieldService;
import com.farm.service.QiNiuService;
import com.farm.service.WeChatService;
import com.farm.util.HttpSendUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FieldServiceImpl
extends ServiceImpl<FieldMapper, Field>
implements FieldService {
    private final FieldMapper fieldMapper;
    @Value(value="${farm.serverUrl}")
    private String serverUrl;
    @Value(value="${wechat.url}")
    private String wechatUrl;
    @Value(value="${qr.envVersion}")
    private String envVersion;
    @Value(value="${qiniu.ip}")
    private String addressIp;
    @Value(value="${farm.codeUrl}")
    private String codeUrl;
    private final QiNiuService qiNiuService;
    private final WeChatService weChatService;

    public JSONObject listField(Field field, Integer page, Integer pageSize) {
        JSONObject result = new JSONObject();
        Page pageInfo = new Page((long)page.intValue(), (long)pageSize.intValue());
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(Field::getDelFlag, (Object)0);
        query.orderByDesc(Field::getId);
        if (StringUtils.isNotBlank((String)field.getFieldName())) {
            query.like(Field::getFieldName, (Object)field.getFieldName());
        }
        if (StringUtils.isNotBlank((String)field.getMapNo())) {
            query.eq(Field::getMapNo, (Object)field.getMapNo());
        }
        if (StringUtils.isNotBlank((String)field.getGoodsId())) {
            query.like(Field::getGoodsId, (Object)field.getGoodsId());
        }
        if (StringUtils.isNotBlank((String)field.getGoodsName())) {
            query.eq(Field::getGoodsName, (Object)field.getGoodsName());
        }
        Page fieldPage = (Page)this.fieldMapper.selectPage((IPage)pageInfo, (Wrapper)query);
        fieldPage.getRecords().forEach(f -> {
            if (StringUtils.isNotBlank((String)f.getRelFieldId())) {
                try {
                    String re = HttpSendUtil.sendHttpGet((String)(this.serverUrl + "field/getFieldInfoByFieldId?hash=x&fieldId=" + f.getRelFieldId()));
                    String fieldName = JSONObject.parseObject((String)re).getJSONObject("resData").getString("FIELD_NAME");
                    f.setRelFieldName(fieldName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        result.put("list", (Object)fieldPage.getRecords());
        result.put("count", (Object)fieldPage.getTotal());
        return result;
    }

    @Transactional
    public boolean upset(Field info) {
        if (info != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)info.getMapNo())) {
            LambdaUpdateWrapper update = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(Field::getMapNo, null)).eq(Field::getMapNo, (Object)info.getMapNo());
            if (StringUtils.isNotBlank((String)info.getRelCodeId())) {
                String result = null;
                try {
                    result = HttpSendUtil.sendHttpGet((String)(this.serverUrl + "fieldCode/detail?companyId=&id=" + info.getRelCodeId()));
                    String codeId = JSONObject.parseObject((String)result).getJSONObject("resData").getJSONObject("detail").getString("oneCode");
                    info.setRelOneCode(codeId);
                    String token = this.weChatService.queryAccessToken("");
                    StringBuilder str = new StringBuilder(this.wechatUrl);
                    str.append("wxa/getwxacodeunlimit?access_token=" + token);
                    JSONObject body = new JSONObject();
                    body.put("page", (Object)"pages/webview/index");
                    body.put("scene", (Object)codeId);
                    body.put("check_path", (Object)false);
                    body.put("env_version", (Object)this.envVersion);
                    try {
                        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                        HttpPost httpPost = new HttpPost(str.toString());
                        httpPost.addHeader("Content-Type", "application/json");
                        httpPost.setEntity((HttpEntity)new StringEntity(body.toJSONString()));
                        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                        InputStream ins = response.getEntity().getContent();
                        byte[] bytes = IOUtils.toByteArray((InputStream)ins);
                        String base64Str = Base64.getEncoder().encodeToString(bytes);
                        String fileName = "dfQr/" + UUID.randomUUID().toString() + ".jpeg";
                        this.qiNiuService.uploadBase64(base64Str, fileName);
                        String qrUrl = this.addressIp + fileName;
                        info.setCodeUrl(qrUrl);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.fieldMapper.update(null, (Wrapper)update);
            return this.saveOrUpdate((Object)info);
        }
        return false;
    }

    public Field getInfo(Field info) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(Field::getMapNo, (Object)info.getMapNo());
        return (Field)this.fieldMapper.selectOne((Wrapper)query);
    }

    public FieldServiceImpl(FieldMapper fieldMapper, QiNiuService qiNiuService, WeChatService weChatService) {
        this.fieldMapper = fieldMapper;
        this.qiNiuService = qiNiuService;
        this.weChatService = weChatService;
    }
}

