/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.farm.bean.MaintenancePlan;
import com.farm.bean.MaintenancePlanProperty;
import com.farm.mapper.MaintenancePlanMapper;
import com.farm.service.MaintenancePlanPropertyService;
import com.farm.service.MaintenancePlanService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MaintenancePlanServiceImpl
extends ServiceImpl<MaintenancePlanMapper, MaintenancePlan>
implements MaintenancePlanService {
    private static final Logger log = LoggerFactory.getLogger(MaintenancePlanServiceImpl.class);
    private final MaintenancePlanMapper planMapper;
    private final MaintenancePlanPropertyService maintenancePlanPropertyService;

    public Integer savePlan(MaintenancePlan plan) {
        String[] split;
        ArrayList<Integer> dayList = new ArrayList<Integer>();
        for (String s : split = plan.getPlanDay().split(",")) {
            dayList.add(Integer.valueOf(s));
        }
        plan.setCron(MaintenancePlanServiceImpl.generateCronExpression((plan.getDateType() == 1 ? 1 : 0) != 0, dayList));
        this.planMapper.insert((Object)plan);
        ArrayList addRel = new ArrayList();
        if (StringUtils.isNotBlank((String)plan.getPropertyIds())) {
            List<String> ids = Arrays.asList(plan.getPropertyIds().split(","));
            ids.forEach(i -> {
                MaintenancePlanProperty maintenancePlanProperty = new MaintenancePlanProperty();
                maintenancePlanProperty.setPlanId(plan.getId());
                maintenancePlanProperty.setPropertyId(Integer.valueOf(Integer.parseInt(i)));
                addRel.add(maintenancePlanProperty);
            });
        }
        this.maintenancePlanPropertyService.saveBatch(addRel);
        return 1;
    }

    public JSONObject listPlan(MaintenancePlan plan, Integer start, Integer pageSize) {
        JSONObject result = new JSONObject();
        result.put("list", (Object)this.planMapper.listPlan(plan, start, pageSize));
        result.put("count", (Object)this.planMapper.countPlan(plan));
        return result;
    }

    public static String generateCronExpression(boolean isMonthly, List<Integer> days) {
        StringBuilder cronExpression = new StringBuilder();
        if (isMonthly) {
            cronExpression.append("0 30 0");
            cronExpression.append(MaintenancePlanServiceImpl.joinList(days));
            cronExpression.append(" * ?");
        } else {
            cronExpression.append("0 30 0 ? * ");
            cronExpression.append(MaintenancePlanServiceImpl.joinList(days));
        }
        return cronExpression.toString();
    }

    private static String joinList(List<Integer> list) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == 31) {
                result.append("L");
            } else {
                result.append(list.get(i));
            }
            if (i >= list.size() - 1) continue;
            result.append(",");
        }
        return result.toString();
    }

    public MaintenancePlanServiceImpl(MaintenancePlanMapper planMapper, MaintenancePlanPropertyService maintenancePlanPropertyService) {
        this.planMapper = planMapper;
        this.maintenancePlanPropertyService = maintenancePlanPropertyService;
    }
}

