/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.farm.bean.AdopterCard;
import com.farm.bean.Order;
import com.farm.bean.OrderSpecification;
import com.farm.bean.bo.OrderUserBo;
import com.farm.bean.bo.OrderUserSpecificationBo;
import com.farm.bean.vo.OrderVo;
import com.farm.exception.ModelException;
import com.farm.mapper.AdopterCardMapper;
import com.farm.mapper.OrderVxMapper;
import com.farm.mapper.UserInfoMapper;
import com.farm.service.OrderVxService;
import com.farm.service.WeChatPayService;
import com.farm.util.ParamAESUtil;
import com.farm.util.WXCharUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderVxServiceImpl
implements OrderVxService {
    @Resource
    private OrderVxService orderVxService;
    @Resource
    private OrderVxMapper orderVxMapper;
    @Resource
    private UserInfoMapper userInfoMapper;
    @Resource
    private AdopterCardMapper adopterCardMapper;
    @Resource
    private WeChatPayService weChatPayService;
    @Value(value="${farm.codeUrl}")
    private String codeUrl;

    public synchronized Map<String, String> createOrder(OrderUserBo bo) {
        return this.orderVxService.createPayOrder(bo);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, String> createPayOrder(OrderUserBo bo) {
        Boolean bl;
        boolean cardOrder = false;
        boolean productBan = false;
        AdopterCard adopterCard = (AdopterCard)this.adopterCardMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdopterCard::getCardNum, (Object)bo.getCardNum())).eq(AdopterCard::getCardPwd, (Object)bo.getCardPwd()));
        if (StringUtils.isNotBlank((String)bo.getCardNum())) {
            if (adopterCard == null || !ParamAESUtil.dealStr((String)bo.getCardPwd(), (int)1).equals(ParamAESUtil.dealStr((String)adopterCard.getCardPwd(), (int)1))) {
                throw new ModelException("\u62b1\u6b49\uff0c\u60a8\u8f93\u5165\u7684\u5361\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
            }
            if (adopterCard.getState() == 1 || adopterCard.getState() == 3) {
                throw new ModelException("\u62b1\u6b49\uff0c\u60a8\u7684\u8ba4\u517b\u5361\u5df2\u5931\u6548\uff01");
            }
            if (adopterCard.getState() == 2 || LocalDate.parse(adopterCard.getExpireDate()).isBefore(LocalDate.now())) {
                throw new ModelException("\u62b1\u6b49\uff0c\u60a8\u7684\u8ba4\u517b\u5361\u5df2\u8fc7\u671f\uff01");
            }
            cardOrder = true;
            adopterCard.setVerifyUserOpenId(bo.getUserId());
            adopterCard.setVerifyDate(LocalDate.now().toString());
        }
        Long productId = cardOrder ? adopterCard.getProductId() : (long)bo.getProductId().intValue();
        String productName = this.orderVxMapper.queryProductNameById(productId, Integer.valueOf(2));
        Integer userId = this.userInfoMapper.queryUserByOpenId(bo.getUserId());
        if (userId == null) {
            throw new ModelException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        Integer shipping = this.userInfoMapper.queryShippingByUserId(bo.getUserId(), bo.getAddressId());
        if (shipping == null) {
            throw new ModelException("\u672a\u627e\u5230\u76f8\u5173\u6536\u8d27\u4fe1\u606f");
        }
        if (productName == null && !cardOrder) {
            throw new ModelException("\u5546\u54c1\u5df2\u4e0b\u67b6,\u65e0\u6cd5\u8d2d\u4e70!");
        }
        if (cardOrder) {
            productBan = true;
            productName = this.orderVxMapper.queryProductNameById(productId, null);
        }
        List<OrderUserSpecificationBo> list = bo.getList();
        if (cardOrder) {
            list = Arrays.asList(new OrderUserSpecificationBo(adopterCard.getSpecificationId(), Integer.valueOf(1)));
        }
        Long sumPrice = 0L;
        ArrayList<OrderSpecification> osList = new ArrayList<OrderSpecification>();
        Order order = new Order();
        for (OrderUserSpecificationBo item : list) {
            OrderSpecification orderSpecification = this.orderVxMapper.queryProduct(item.getSpecificationId(), (Integer)(cardOrder && productBan ? null : Integer.valueOf(2)));
            this.querySpecification(orderSpecification, item);
            sumPrice = sumPrice + (long)item.getNum().intValue() * orderSpecification.getPrice();
            osList.add(orderSpecification);
        }
        order.setPrice(sumPrice);
        order.setPayment(sumPrice);
        order.setAddressId(bo.getAddressId());
        order.setFieldId(cardOrder ? adopterCard.getFieldId() : bo.getFieldId());
        order.setUserId(bo.getUserId());
        order.setStatus(Integer.valueOf(0));
        order.setCardOrder(Integer.valueOf(cardOrder ? 1 : 0));
        order.setFreight(Long.valueOf(0L));
        order.setProductId(productId);
        order.setProductName(productName);
        do {
            try {
                String orderNum = DateUtil.format((Date)DateUtil.date(), (String)"yyyyMMddHHmmss") + RandomUtil.randomNumbers((int)3);
                order.setOrderNum(orderNum);
                this.orderVxMapper.createPayOrder(order);
                this.orderVxMapper.createPayOrderSpecification(order.getId(), osList);
                bl = false;
            }
            catch (DuplicateKeyException e) {
                bl = true;
            }
        } while (bl.booleanValue());
        if (cardOrder) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            this.weChatPayService.orderSucceeded(order.getOrderNum());
            this.adopterCardMapper.redeemCard(adopterCard);
            resultMap.put("msg", "\u606d\u559c\uff0c\u8ba4\u517b\u6210\u529f\uff01");
            return resultMap;
        }
        return WXCharUtil.wxPay((String)order.getUserId(), (String)order.getOrderNum(), (Long)order.getPayment());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void orderPaymentFailureHandle(Integer min) {
        List list = this.orderVxMapper.queryExpiredOrder(min);
        if (list.size() > 0) {
            this.orderVxMapper.delExpiredOrder(list);
            this.orderVxMapper.upSpecification(list);
        }
    }

    public JSONObject queryOrderList(Integer status, String userId, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer start = 0;
        if (pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        List list = this.orderVxMapper.queryOrderList(status, userId, start, pageSize);
        Integer count = this.orderVxMapper.queryOrderCount(status, userId);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public OrderVo queryOrderDetail(String orderNum) {
        return this.orderVxMapper.queryOrderDetail(orderNum);
    }

    private void querySpecification(OrderSpecification orderSpecification, OrderUserSpecificationBo item) {
        if (orderSpecification == null) {
            throw new ModelException("\u5546\u54c1\u5df2\u4e0b\u67b6,\u65e0\u6cd5\u8d2d\u4e70");
        }
        if (orderSpecification.getNum() <= 0) {
            throw new ModelException("\u5546\u54c1\u6570\u91cf\u4e0d\u8db3,\u65e0\u6cd5\u8d2d\u4e70");
        }
        Integer num = this.orderVxMapper.queryOrderSpecificationNum(item.getSpecificationId());
        Integer lockCard = this.adopterCardMapper.countLockCard(item.getSpecificationId());
        num = num == null ? 0 : num;
        if (orderSpecification.getNum() - num - lockCard - item.getNum() < 0) {
            throw new ModelException("\u5546\u54c1\u6570\u91cf\u4e0d\u8db3,\u65e0\u6cd5\u8d2d\u4e70");
        }
        orderSpecification.setNum(item.getNum());
    }

    public JSONObject queryOrderRecordList(String userId, Integer page, Integer pageSize) {
        JSONObject result = new JSONObject();
        List orderLogVos = this.orderVxMapper.myAllOrderRecordList(userId);
        orderLogVos.forEach(o -> {
            if (StringUtils.isNotBlank((String)o.getFieldCodeUrl())) {
                o.setFieldCodeUrl(this.codeUrl + o.getFieldCodeUrl());
            }
        });
        result.put("list", (Object)orderLogVos);
        return result;
    }

    public Integer cancelOrder(String orderNum) {
        return this.orderVxMapper.upExpiredOrderByOrderNum(orderNum);
    }

    public Integer delOrder(String orderNum) {
        return this.orderVxMapper.delOrder(orderNum);
    }

    public Integer confirmReceipt(String orderNum) {
        return this.orderVxMapper.confirmReceipt(orderNum);
    }
}

