/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.api.SubscribeWithMap;
import com.farm.bean.express.BaseRequest;
import com.farm.bean.express.SubscribeParam;
import com.farm.bean.express.SubscribeParameters;
import com.farm.bean.express.SubscribeReq;
import com.farm.bean.vo.ExpressBillVo;
import com.farm.config.ExpressConfig;
import com.farm.exception.ModelException;
import com.farm.mapper.OrderWebMapper;
import com.farm.service.OrderWebService;
import com.farm.util.HttpResult;
import com.google.gson.Gson;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderWebServiceImpl
implements OrderWebService {
    @Resource
    private OrderWebMapper orderWebMapper;

    public JSONObject queryWebOrderList(String orderNum, String fieldName, String specificationName, Integer status, String nickName, String phone, String rangTime, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer start = 0;
        if (pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        String startTime = null;
        String endTime = null;
        if (!rangTime.isEmpty()) {
            String[] split = rangTime.split(",");
            startTime = split[0];
            endTime = split[1];
        }
        List list = this.orderWebMapper.queryWebOrderList(orderNum, fieldName, specificationName, status, nickName, phone, startTime, endTime, start, pageSize);
        Integer count = this.orderWebMapper.queryWebOrderListCount(orderNum, fieldName, specificationName, status, nickName, phone, startTime, endTime);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Integer deliverGoods(String orderNum, String expressCode, String expressName, String expressNum) {
        String phone = this.orderWebMapper.queryDeilverPhoneByOrderNum(orderNum);
        if (phone == null || phone.isEmpty()) {
            throw new ModelException("\u627e\u4e0d\u5230\u6536\u8d27\u4eba\u4e86\u8054\u7cfb\u65b9\u5f0f\uff01\u65e0\u6cd5\u53d1\u8d27");
        }
        this.orderWebMapper.deliverGoods(orderNum, expressCode, expressNum, expressName, Integer.valueOf(2));
        SubscribeParameters subscribeParameters = new SubscribeParameters();
        subscribeParameters.setCallbackurl(ExpressConfig.callBackExpress);
        subscribeParameters.setSalt(orderNum);
        subscribeParameters.setPhone(phone);
        SubscribeParam subscribeParam = new SubscribeParam();
        subscribeParam.setParameters(subscribeParameters);
        subscribeParam.setCompany(expressCode);
        subscribeParam.setNumber(expressNum);
        subscribeParam.setKey(ExpressConfig.key);
        SubscribeReq subscribeReq = new SubscribeReq();
        subscribeReq.setSchema("json");
        subscribeReq.setParam(new Gson().toJson((Object)subscribeParam));
        SubscribeWithMap subscribe = new SubscribeWithMap();
        HttpResult execute = subscribe.execute((BaseRequest)subscribeReq);
        if (execute.getStatus() != 200) {
            throw new ModelException("\u53d1\u8d27\u5931\u8d25," + execute.getError());
        }
        return 1;
    }

    public Integer verifyReceive(Integer id) {
        return this.orderWebMapper.verifyReceive(id);
    }

    public List<ExpressBillVo> queryExpressInfo(String orderNum) {
        return this.orderWebMapper.queryExpressInfo(orderNum);
    }
}

