/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.service.QiNiuService;
import com.farm.util.HttpDownloadUtil;
import com.qiniu.common.QiniuException;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FetchRet;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.UrlSafeBase64;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QiNiuServiceImpl
implements QiNiuService {
    private static final Logger log = LoggerFactory.getLogger(QiNiuServiceImpl.class);
    private final UploadManager uploadManager;
    private final Auth auth;
    @Value(value="${qiniu.bucket}")
    private String bucket;
    @Value(value="${qiniu.accessKey}")
    private String accessKey;
    @Value(value="${qiniu.secretKey}")
    private String secretKey;
    private StringMap putPolicy;
    @Value(value="${qiniu.ip}")
    private String addressIp;

    @Autowired
    public QiNiuServiceImpl(UploadManager uploadManager, Auth auth) {
        this.uploadManager = uploadManager;
        this.auth = auth;
    }

    public com.qiniu.http.Response uploadFile(InputStream in, long size, String fileName) throws IOException {
        String prefix = "farm/";
        com.qiniu.http.Response response = this.uploadManager.put(in, size, prefix + fileName, this.getUploadToken(), new StringMap(), null, false);
        for (int retry = 0; response.needRetry() && retry < 3; ++retry) {
            response = this.uploadManager.put(in, size, prefix + fileName, this.getUploadToken(), new StringMap(), null, false);
        }
        return response;
    }

    public com.qiniu.http.Response uploadFile(byte[] buffer, String fileName) throws IOException {
        com.qiniu.http.Response response = this.uploadManager.put(buffer, "farm/" + fileName, this.getUploadToken());
        for (int retry = 0; response.needRetry() && retry < 3; ++retry) {
            response = this.uploadManager.put(buffer, "farm/" + fileName, this.getUploadToken());
        }
        return response;
    }

    public com.qiniu.http.Response uploadFile(File file) throws QiniuException {
        String prefix = "farm/";
        com.qiniu.http.Response response = this.uploadManager.put(file, prefix + file.getName(), this.getUploadToken());
        for (int retry = 0; response.needRetry() && retry < 3; ++retry) {
            response = this.uploadManager.put(file, prefix + file.getName(), this.getUploadToken());
        }
        return response;
    }

    private String getUploadToken() {
        return this.auth.uploadToken(this.bucket, null, 3600L, this.putPolicy);
    }

    public void uploadUrl(String remoteUrl, String key) throws QiniuException {
        Auth auth = Auth.create((String)this.accessKey, (String)this.secretKey);
        Configuration cfg = new Configuration(Region.region0());
        BucketManager bucketManager = new BucketManager(auth, cfg);
        try {
            FetchRet fetchRet = bucketManager.fetch(remoteUrl, "farm", key);
        }
        catch (QiniuException e) {
            e.printStackTrace();
        }
    }

    public String uploadBase64(String base64Img, String fileUrl) {
        String url = "http://upload.qiniup.com/putb64/-1/key/" + UrlSafeBase64.encodeToString((String)fileUrl);
        RequestBody rb = RequestBody.create(null, (String)base64Img);
        Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/octet-stream").addHeader("Authorization", "UpToken " + this.getUploadToken()).post(rb).build();
        OkHttpClient client = new OkHttpClient();
        Response response = null;
        try {
            response = client.newCall(request).execute();
            if (response != null && response.code() == 200) {
                response.close();
                return "success";
            }
        }
        catch (IOException e) {
            response.close();
            e.printStackTrace();
        }
        return "error";
    }

    public String deleteFile(String fileName) {
        Auth auth = Auth.create((String)this.accessKey, (String)this.secretKey);
        Configuration cfg = new Configuration(Region.region0());
        BucketManager bucketManager = new BucketManager(auth, cfg);
        try {
            bucketManager.delete(this.bucket, fileName);
        }
        catch (QiniuException ex) {
            System.err.println(ex.code());
            System.err.println(ex.response.toString());
        }
        return "success";
    }

    public void put64image(String file64) throws Exception {
        String url = "http://upload.qiniup.com/putb64/key/" + UrlSafeBase64.encodeToString((String)"");
        RequestBody rb = RequestBody.create(null, (String)file64);
        Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/octet-stream").addHeader("Authorization", "UpToken " + this.getUploadToken()).post(rb).build();
        OkHttpClient client = new OkHttpClient();
        Response response = client.newCall(request).execute();
    }

    public String saveFile(String path) {
        String filePath = System.getProperty("user.dir") + File.separator + "tmp" + File.separator;
        String fileName = HttpDownloadUtil.download((String)path, (String)filePath);
        File uploadFile = new File(filePath + fileName);
        File file = new File(filePath + UUID.randomUUID().toString().substring(0, 9) + fileName);
        uploadFile.renameTo(file);
        String url = null;
        try {
            com.qiniu.http.Response response = this.uploadFile(file);
            if (response.isOK()) {
                String yunFileName = JSONObject.parseObject((String)response.bodyString()).getString("key");
                url = this.addressIp + yunFileName;
                uploadFile.delete();
                file.delete();
            } else {
                log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)JSONObject.parseObject((String)response.toString()));
            }
        }
        catch (QiniuException e) {
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)e.getMessage());
        }
        return url;
    }

    public String saveFile(File uploadFile) {
        String url = null;
        try {
            com.qiniu.http.Response response = this.uploadFile(uploadFile);
            if (response.isOK()) {
                String yunFileName = JSONObject.parseObject((String)response.bodyString()).getString("key");
                url = this.addressIp + yunFileName;
                uploadFile.delete();
            } else {
                log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)JSONObject.parseObject((String)response.toString()));
            }
        }
        catch (QiniuException e) {
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)e.getMessage());
        }
        return url;
    }
}

