/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.farm.bean.Certificate;
import com.farm.bean.Order;
import com.farm.bean.OrderSpecification;
import com.farm.bean.vo.AppProductDetailVo;
import com.farm.exception.ModelException;
import com.farm.mapper.OrderVxMapper;
import com.farm.service.CertificateService;
import com.farm.service.WeChatPayService;
import com.farm.util.WXCharUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WeChatPayServiceImpl
implements WeChatPayService {
    @Resource
    private WeChatPayService weChatPayService;
    @Resource
    private OrderVxMapper orderVxMapper;
    @Resource
    private CertificateService certificateService;

    public synchronized void orderSucceeded(String orderNumber) {
        this.weChatPayService.orderPaySucceeded(orderNumber);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void orderPaySucceeded(String orderNumber) {
        Integer count = this.orderVxMapper.queryCertificateCount(orderNumber);
        if (count > 0) {
            return;
        }
        if (orderNumber == null || orderNumber.equals("")) {
            throw new ModelException("\u8ba2\u5355\u53f7\u4e3a\u7a7a");
        }
        List order = this.orderVxMapper.queryOrderInfo(orderNumber);
        if (order == null || order.size() == 0) {
            throw new ModelException("\u672a\u627e\u5230\u6307\u5b9a\u8ba2\u5355");
        }
        for (OrderSpecification item : order) {
            int i = this.orderVxMapper.outTakeNum(item);
            if (i != 0) continue;
            throw new ModelException("\u5e93\u5b58\u6263\u9664\u5931\u8d25");
        }
        this.orderVxMapper.updateOrderStatus(orderNumber);
        Certificate certificate = this.orderVxMapper.queryCertificateOrderDetail(orderNumber);
        this.certificateService.upset(certificate);
    }

    public Map<String, String> orderAgainPayment(String userId, String orderNum) {
        Order order = this.orderVxMapper.queryOrder(userId, orderNum, Integer.valueOf(20));
        if (order == null) {
            throw new ModelException("\u8ba2\u5355\u8d85\u51fa\u652f\u4ed8\u65f6\u95f4\uff0c\u5df2\u9500\u6bc1\u6216\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u5b8c\u6210!");
        }
        Long payment = order.getPayment() == null ? order.getPayment() : order.getPrice();
        AppProductDetailVo appProductDetailVo = this.orderVxMapper.queryProductById(order.getProductId());
        if (appProductDetailVo == null || appProductDetailVo.getStatus() == 1) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(order.getId());
            this.orderVxMapper.upSpecification(list);
            throw new ModelException("\u5546\u54c1\u5df2\u552e\u7f44\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7530\u5757\u4f5c\u7269\u8ba4\u517b\uff01");
        }
        Map map = WXCharUtil.wxPay((String)order.getUserId(), (String)order.getOrderNum(), (Long)payment);
        if (map.get("err_code_des") != null) {
            throw new ModelException((String)map.get("err_code_des"));
        }
        return map;
    }
}

