/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.farm.bean.UserInfo;
import com.farm.service.UserInfoService;
import com.farm.service.WeChatService;
import com.farm.util.HttpSendUtil;
import com.farm.util.RedisUtil;
import com.farm.util.WxAESUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WeChatServiceImpl
implements WeChatService {
    private static final Logger log = LoggerFactory.getLogger(WeChatServiceImpl.class);
    @Value(value="${wechat.url}")
    private String wechatUrl;
    @Value(value="${wechat.appId}")
    private String wechatAppId;
    @Value(value="${wechat.appSecret}")
    private String wechatAppSecret;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private RedisUtil redisUtil;

    public String queryAccessToken(String code) {
        if (this.redisUtil.exists("wxAccessToken").booleanValue()) {
            return this.redisUtil.getObject("wxAccessToken");
        }
        JSONObject json = null;
        try {
            StringBuilder str = new StringBuilder(this.wechatUrl);
            str.append("cgi-bin/token?appid=" + this.wechatAppId + "&secret=" + this.wechatAppSecret + "&grant_type=client_credential");
            if (StringUtils.isNotBlank((String)code)) {
                str.append("&code" + code);
            }
            String result = HttpSendUtil.sendHttpGet((String)str.toString());
            log.info("\u901a\u8fc7code\u6362\u53d6\u7f51\u9875\u6388\u6743access_token\u7ed3\u679c\uff1a" + result);
            json = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            log.error("\u901a\u8fc7code\u6362\u53d6\u7f51\u9875\u6388\u6743access_token\u9519\u8bef\uff1a" + e.getMessage());
        }
        String access_token = json.getString("access_token");
        this.redisUtil.setnx("wxAccessToken", access_token, Integer.valueOf(60), TimeUnit.MINUTES);
        return access_token;
    }

    public Object queryPhone(String loginCode, String encryptedData, String iv) {
        String phone = null;
        JSONObject jsonObject = null;
        try {
            JSONObject json = this.queryCode2Session(loginCode);
            if (json != null && StringUtils.isNotBlank((String)json.getString("openid"))) {
                JSONObject object = this.decryptedData(encryptedData, json.getString("session_key"), iv);
                log.info("xxxx" + object.toJSONString());
                UserInfo user = (UserInfo)this.userInfoService.getOne((Wrapper)new QueryWrapper().eq((Object)"wx_open_id", (Object)json.getString("openid")));
                if (user != null) {
                    return user;
                }
                jsonObject = this.decryptedData(encryptedData, json.getString("session_key"), iv);
                phone = jsonObject.getString("phoneNumber");
                String openId = json.getString("openid");
                UserInfo usersDto = UserInfo.builder().id(user != null ? user.getId() : null).phone(phone).wxOpenId(openId).avatorWx("").nickName("").build();
                this.userInfoService.saveOrUpdate((Object)usersDto, (Wrapper)new QueryWrapper().eq((Object)"phone", (Object)phone));
                UserInfo phone1 = (UserInfo)this.userInfoService.getOne((Wrapper)new QueryWrapper().eq((Object)"phone", (Object)phone));
                return phone1;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u624b\u673a\u53f7\u9519\u8bef\uff1a" + e.getMessage());
        }
        return jsonObject;
    }

    public JSONObject queryCode2Session(String loginCode) {
        JSONObject json = null;
        try {
            StringBuilder str = new StringBuilder(this.wechatUrl);
            str.append("sns/jscode2session?appid=" + this.wechatAppId + "&secret=" + this.wechatAppSecret + "&js_code=" + loginCode + "&grant_type=authorization_code");
            String result = HttpSendUtil.sendHttpGet((String)str.toString());
            log.info("\u67e5\u8be2Code2Session\u7ed3\u679c\uff1a" + result);
            json = JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2Code2Session\u9519\u8bef\uff1a" + e.getMessage());
        }
        return json;
    }

    public JSONObject decryptedData(String encryptedData, String sessionKey, String iv) {
        log.info("encryptedData:{}", (Object)encryptedData);
        log.info("sessionKey:{}", (Object)sessionKey);
        log.info("iv:{}", (Object)iv);
        String decrypt = WxAESUtils.decrypt((String)encryptedData, (String)sessionKey, (String)iv);
        return JSONObject.parseObject((String)decrypt);
    }
}

