/*
 * Decompiled with CFR 0.152.
 */
package com.farm.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.farm.bean.Maintenance;
import com.farm.bean.MaintenancePlan;
import com.farm.service.MaintenancePlanService;
import com.farm.service.MaintenanceService;
import com.farm.util.ResultVo;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dp/maintenancePlanTask"})
public class MaintenancePlanTask {
    private static final Logger log = LoggerFactory.getLogger(MaintenancePlanTask.class);
    private final MaintenancePlanService maintenancePlanService;
    private final MaintenanceService maintenanceService;

    @GetMapping(value={"/planTask"})
    public ResultVo planTask() {
        List dataList = this.maintenancePlanService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaintenancePlan::getDelFlag, (Object)0)).eq(MaintenancePlan::getState, (Object)1));
        ArrayList addList = new ArrayList();
        dataList.forEach(d -> {
            try {
                boolean dateMatch;
                Date date = new Date();
                Calendar currentCalendar = Calendar.getInstance();
                currentCalendar.setTime(date);
                Date nextExecutionDate = new CronExpression(d.getCron()).getNextValidTimeAfter(date);
                boolean bl = dateMatch = currentCalendar.get(5) == nextExecutionDate.getDate();
                if (dateMatch) {
                    List<String> propertys = Arrays.asList(d.getPropertyIds().split(","));
                    propertys.forEach(p -> {
                        Maintenance maintenance = new Maintenance();
                        maintenance.setPropertyId(Integer.valueOf(Integer.parseInt(p)));
                        maintenance.setMaintenanceName(d.getPlanName());
                        maintenance.setContent(d.getPlanContent());
                        maintenance.setPlanDate(LocalDate.now().toString().replace("T", " "));
                        maintenance.setState(Integer.valueOf(0));
                        addList.add(maintenance);
                    });
                    log.info("\u5f53\u524d\u65e5\u671f\u7b26\u5408Cron\u8868\u8fbe\u5f0f" + d.getCron());
                } else {
                    log.error("\u5f53\u524d\u65e5\u671f\u4e0d\u7b26\u5408Cron\u8868\u8fbe\u5f0f" + d.getCron());
                }
            }
            catch (ParseException e) {
                log.info("Cron\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef:", (Throwable)e);
                e.printStackTrace();
            }
        });
        this.maintenanceService.saveBatch(addList);
        return ResultVo.success();
    }

    public static void main(String[] args) {
        try {
            Date nextExecutionDate = new CronExpression("0 59 9 16,17,18 * ?").getNextValidTimeAfter(new Date());
            System.out.println(nextExecutionDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public MaintenancePlanTask(MaintenancePlanService maintenancePlanService, MaintenanceService maintenanceService) {
        this.maintenancePlanService = maintenancePlanService;
        this.maintenanceService = maintenanceService;
    }
}

