/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class BaseMail {
    private static final Logger logger = LoggerFactory.getLogger(BaseMail.class);
    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    private MailProperties mailProperties;

    public void sendMsgAndFile(String to, String title, String text, String affixName, byte[] bytes) {
        MimeMessage message = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        try {
            helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.mailProperties.getUsername());
            helper.setTo(to);
            helper.setText(text);
            helper.setSubject(title);
            helper.addAttachment(affixName, (InputStreamSource)new ByteArrayResource(bytes));
            this.javaMailSender.send(message);
        }
        catch (Exception e) {
            String err = e.getMessage();
            logger.error("send email error: " + err);
        }
    }
}

