/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import cn.hutool.core.io.IoUtil;
import cn.hutool.json.JSONObject;
import com.farm.util.HttpResult;
import com.farm.util.ObjectToMapUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static final String CHARSET_DEFAULT = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult doPost(String url, Object obj, int connectTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        HttpResult result = new HttpResult();
        try {
            Map params = ObjectToMapUtils.objectToMap((Object)obj);
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
            httpPost.setConfig(requestConfig);
            if (params != null && params.size() > 0) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (Map.Entry entry : params.entrySet()) {
                    list.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, CHARSET_DEFAULT));
            }
            resp = httpClient.execute((HttpUriRequest)httpPost);
            String body = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)CHARSET_DEFAULT);
            int statusCode = resp.getStatusLine().getStatusCode();
            result.setStatus(statusCode);
            result.setBody(body);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != resp) {
                try {
                    resp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult doPostFile(String url, File file, int connectTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        HttpResult result = new HttpResult();
        try {
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
            httpPost.setConfig(requestConfig);
            builder.addBinaryBody("file", (InputStream)new FileInputStream(file), ContentType.MULTIPART_FORM_DATA, file.getName());
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            resp = httpClient.execute((HttpUriRequest)httpPost);
            result.setStatus(resp.getStatusLine().getStatusCode());
            result.setBody(EntityUtils.toString((HttpEntity)resp.getEntity(), (String)CHARSET_DEFAULT));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != resp) {
                try {
                    resp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static InputStream postInputStream(String urlStr, JSONObject paramJson) throws Exception {
        URL url = new URL(urlStr);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
        printWriter.write(paramJson.toString());
        printWriter.flush();
        String contentType = httpURLConnection.getContentType();
        if (contentType.contains("json")) {
            IoUtil.copy((InputStream)httpURLConnection.getInputStream(), (OutputStream)System.out);
            throw new IllegalArgumentException("\u8c03\u7528\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u751f\u6210\u63a5\u53e3\u51fa\u9519");
        }
        return httpURLConnection.getInputStream();
    }
}

