/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="redisUtil")
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Autowired
    @Qualifier(value="redisTemplate10")
    private StringRedisTemplate redisTemplate;

    public void setObject(String key, String value, long timeout, TimeUnit unit) {
        try {
            log.debug("setObject: key :" + key);
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, timeout, unit);
        }
        catch (Exception e) {
            log.error("setObject: key :" + key);
        }
    }

    public void delObject(String key) {
        try {
            this.redisTemplate.delete((Object)key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public List<String> page(String key, int curr, int limit) {
        return this.redisTemplate.opsForList().range((Object)key, (long)((curr - 1) * limit), (long)(curr * limit));
    }

    public long count(String key) {
        long total = 0L;
        total = this.redisTemplate.opsForList().size((Object)key);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObject(String key) {
        String result = "";
        try {
            log.debug("getObject - index - key :6:" + key);
            if (StringUtils.isNotBlank((String)key)) {
                result = (String)this.redisTemplate.opsForValue().get((Object)key);
                return result;
            }
        }
        catch (Exception exception) {}
        finally {
            return result;
        }
    }

    public void setData(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public Boolean setnx(String key, String value, Integer time, TimeUnit unit) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, (long)time.intValue(), unit);
    }

    public void setLpush(String key, String value) {
        try {
            log.debug("setLpush: key :" + key);
            this.redisTemplate.opsForList().leftPush((Object)key, (Object)value);
        }
        catch (Exception e) {
            log.error("setLpush: key :" + key);
        }
    }

    public Boolean setnxVal(String key, String val, Integer time) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)val, (long)time.intValue(), TimeUnit.SECONDS);
    }
}

