/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.farm.bean.WXPayConfig;
import com.farm.util.HttpSendUtil;
import com.farm.util.PayUtil;
import com.farm.util.WXPayConstants;
import com.farm.util.WXPayUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WXCharUtil {
    private static final Logger log = LoggerFactory.getLogger(WXCharUtil.class);

    public static Map<String, String> wxPay(String userId, String orderNumber, Long price) {
        DateTime date = DateUtil.date();
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> wxPayConfig = new HashMap<String, String>();
        wxPayConfig.put("wx_appid", WXPayConfig.wxAppid);
        wxPayConfig.put("mch_id", WXPayConfig.mchId);
        wxPayConfig.put("paternerKey", WXPayConfig.paternerKey);
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("appid", wxPayConfig.get("wx_appid").toString());
            param.put("body", "\u5546\u54c1\u4e0d\u9519");
            param.put("mch_id", wxPayConfig.get("mch_id").toString());
            param.put("nonce_str", WXPayUtil.generateNonceStr());
            param.put("notify_url", WXPayConfig.notifyUrl);
            param.put("openid", userId);
            param.put("out_trade_no", orderNumber);
            param.put("spbill_create_ip", "180.111.168.215");
            param.put("total_fee", price.toString());
            param.put("trade_type", "JSAPI");
            param.put("time_start", DateUtil.format((Date)date, (String)"yyyyMMddHHmmss"));
            param.put("time_expire", DateUtil.format((Date)DateUtil.offset((Date)date, (DateField)DateField.MINUTE, (int)30), (String)"yyyyMMddHHmmss"));
            String sign = WXPayUtil.generateSignature(param, (String)wxPayConfig.get("paternerKey").toString());
            param.put("sign", sign);
            String xml = WXPayUtil.mapToXml(param);
            log.debug("XML\u6570\u636e\u4e3a [{}]", (Object)xml);
            String url = "https://api.mch.weixin.qq.com//pay/unifiedorder";
            log.debug("url \u8def\u5f84\u4e3a\uff1a{}", (Object)url);
            String xmlStr = HttpSendUtil.sendHttpPost((String)url, (String)"", (String)"", (String)xml);
            System.out.println("-----------------" + xmlStr);
            log.debug("\u8fd4\u56de\u6570\u636e\u4e3a\uff1a[{}]", (Object)xmlStr);
            Map stringStringMap = WXPayUtil.xmlToMap((String)xmlStr);
            result.put("appId", wxPayConfig.get("wx_appid").toString());
            result.put("timeStamp", WXPayUtil.getCurrentTimestamp() + "");
            result.put("nonceStr", WXPayUtil.generateNonceStr());
            result.put("signType", "MD5");
            result.put("package", "prepay_id=" + (String)stringStringMap.get("prepay_id"));
            result.put("paySign", WXPayUtil.generateSignature(result, (String)wxPayConfig.get("paternerKey").toString()));
            result.put("err_code_des", (String)stringStringMap.get("err_code_des"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map<String, String> orderquery(String orderNumber) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appid", WXPayConfig.wxAppid);
        param.put("mch_id", WXPayConfig.mchId);
        param.put("out_trade_no", orderNumber);
        param.put("nonce_str", WXPayUtil.generateNonceStr());
        String url = "https://api.mch.weixin.qq.com//pay/orderquery";
        String sign = WXPayUtil.generateSignature(param, (String)WXPayConfig.paternerKey);
        param.put("sign", sign);
        String xml = WXPayUtil.mapToXml(param);
        String s = HttpSendUtil.sendHttpPost((String)url, (String)"", (String)"", (String)xml);
        Map map = PayUtil.doXMLParse((String)s);
        return map;
    }

    public static String downloadbill() throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appid", WXPayConfig.wxAppid);
        param.put("mch_id", WXPayConfig.mchId);
        param.put("nonce_str", WXPayUtil.generateNonceStr());
        param.put("bill_type", "ALL");
        param.put("bill_date", "20220408");
        String url = "https://api.mch.weixin.qq.com//pay/downloadbill";
        String sign = WXPayUtil.generateSignature(param, (String)WXPayConfig.paternerKey);
        param.put("sign", sign);
        String xml = WXPayUtil.mapToXml(param);
        System.out.println(xml);
        String s = HttpSendUtil.sendHttpPost((String)url, (String)"", (String)"", (String)xml);
        return s;
    }

    public static Map<String, String> orderRefund(String orderNumber, String returnUuid, Integer totalFee, Integer refundFee) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appid", WXPayConfig.wxAppid);
        param.put("mch_id", WXPayConfig.mchId);
        param.put("out_trade_no", orderNumber);
        param.put("nonce_str", WXPayUtil.generateNonceStr());
        param.put("out_refund_no", returnUuid);
        param.put("total_fee", totalFee.toString());
        param.put("refund_fee", refundFee.toString());
        param.put("refund_desc", "\u5ba2\u6237\u9000\u6b3e");
        param.put("notify_url", WXPayConfig.orderRefundNotifyUrl);
        String url = "https://api.mch.weixin.qq.com//secapi/pay/refund";
        String sign = WXPayUtil.generateSignature(param, (String)WXPayConfig.paternerKey);
        param.put("sign", sign);
        String xml = WXPayUtil.mapToXml(param);
        System.out.println(xml);
        String s = WXCharUtil.requestOnce((String)"api.mch.weixin.qq.com", (String)"/secapi/pay/refund", (String)xml, (int)8000, (int)10000, (boolean)true);
        Map map = PayUtil.doXMLParse((String)s);
        System.out.println(map);
        return map;
    }

    public static Map<String, String> queryOrderRefund(String orderNumber, String returnUuid) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appid", WXPayConfig.wxAppid);
        param.put("mch_id", WXPayConfig.mchId);
        param.put("nonce_str", WXPayUtil.generateNonceStr());
        param.put("out_refund_no", returnUuid);
        String url = "https://api.mch.weixin.qq.com/pay/refundquery";
        String sign = WXPayUtil.generateSignature(param, (String)WXPayConfig.paternerKey);
        param.put("sign", sign);
        String xml = WXPayUtil.mapToXml(param);
        System.out.println(xml);
        String s = HttpSendUtil.sendHttpPost((String)url, (String)"", (String)"", (String)xml);
        Map map = PayUtil.doXMLParse((String)s);
        System.out.println(map);
        return map;
    }

    private static String requestOnce(String domain, String urlSuffix, String data, int connectTimeoutMs, int readTimeoutMs, boolean useCert) throws Exception {
        BasicHttpClientConnectionManager connManager;
        if (useCert) {
            char[] password = WXPayConfig.mchId.toCharArray();
            ByteArrayInputStream certStream = new ByteArrayInputStream(WXPayConfig.certData);
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(certStream, password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, password);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
            connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build(), null, null, null);
        } else {
            connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build(), null, null, null);
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
        String url = "https://" + domain + urlSuffix;
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeoutMs).setConnectTimeout(connectTimeoutMs).build();
        httpPost.setConfig(requestConfig);
        StringEntity postEntity = new StringEntity(data, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.addHeader("User-Agent", WXPayConstants.USER_AGENT + " " + WXPayConfig.mchId);
        httpPost.setEntity((HttpEntity)postEntity);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity httpEntity = httpResponse.getEntity();
        return EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
    }

    public static String getAccessToken() {
        String appid = WXPayConfig.wxAppid;
        String secret = WXPayConfig.appSecret;
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + appid + "&secret=" + secret;
        String result = HttpUtil.get((String)url);
        JSONObject jsonObject = JSONUtil.parseObj((String)result);
        return jsonObject.get((Object)"access_token").toString();
    }

    public static byte[] encrypt(byte[] plainBytes, PublicKey publicKey, int keyLength, int reserveSize, String cipherAlgorithm) throws Exception {
        int keyByteSize = keyLength / 8;
        int encryptBlockSize = keyByteSize - reserveSize;
        int nBlock = plainBytes.length / encryptBlockSize;
        if (plainBytes.length % encryptBlockSize != 0) {
            ++nBlock;
        }
        ByteArrayOutputStream outbuf = null;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(1, publicKey);
            outbuf = new ByteArrayOutputStream(nBlock * keyByteSize);
            for (int offset = 0; offset < plainBytes.length; offset += encryptBlockSize) {
                int inputLen = plainBytes.length - offset;
                if (inputLen > encryptBlockSize) {
                    inputLen = encryptBlockSize;
                }
                byte[] encryptedBlock = cipher.doFinal(plainBytes, offset, inputLen);
                outbuf.write(encryptedBlock);
            }
            outbuf.flush();
            byte[] byArray = outbuf.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new Exception("ENCRYPT ERROR:", e);
        }
        finally {
            try {
                if (outbuf != null) {
                    outbuf.close();
                }
            }
            catch (Exception e) {
                outbuf = null;
                throw new Exception("CLOSE ByteArrayOutputStream ERROR:", e);
            }
        }
    }
}

