/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxAESUtils {
    private static final Logger log = LoggerFactory.getLogger(WxAESUtils.class);
    private static final String ALGORITHM = "AES/CBC/PKCS7Padding";
    private static final String CHARSET_NAME = "UTF-8";
    private static final String AES_NAME = "AES";

    public static String decrypt(String content, String key, String iv) {
        String result = "";
        byte[] dataByte = Base64.decodeBase64((String)content);
        byte[] keyByte = Base64.decodeBase64((String)key);
        byte[] ivByte = Base64.decodeBase64((String)iv);
        try {
            byte[] temp;
            int groups;
            int base = 16;
            if (keyByte.length % base != 0) {
                groups = keyByte.length / base + (keyByte.length % base != 0 ? 1 : 0);
                temp = new byte[groups * base];
                Arrays.fill(temp, (byte)0);
                System.arraycopy(keyByte, 0, temp, 0, keyByte.length);
                keyByte = temp;
            }
            if (ivByte.length % base != 0) {
                groups = ivByte.length / base + (ivByte.length % base != 0 ? 1 : 0);
                temp = new byte[groups * base];
                Arrays.fill(temp, (byte)0);
                System.arraycopy(ivByte, 0, temp, 0, ivByte.length);
                ivByte = temp;
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance(ALGORITHM, "BC");
            SecretKeySpec spec = new SecretKeySpec(keyByte, AES_NAME);
            AlgorithmParameters parameters = AlgorithmParameters.getInstance(AES_NAME);
            parameters.init(new IvParameterSpec(ivByte));
            cipher.init(2, (Key)spec, parameters);
            byte[] resultByte = cipher.doFinal(dataByte);
            if (null != resultByte && resultByte.length > 0) {
                result = new String(resultByte, CHARSET_NAME);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidParameterSpecException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

