/*
 * Decompiled with CFR 0.152.
 */
package com.farm.config;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExcelListener<T>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(ExcelListener.class);
    public List<JSONObject> list = new ArrayList();
    private Class toClass;
    private List<String> fieldList = new ArrayList();
    private JSONObject modelObject = new JSONObject();

    public List<String> getFieldList() {
        return this.fieldList;
    }

    private void init() {
        Field[] fields;
        for (Field field : fields = this.toClass.getDeclaredFields()) {
            this.fieldList.add(field.getName());
            this.modelObject.put(field.getName(), (Object)"");
        }
    }

    private ExcelListener() {
    }

    public ExcelListener(Class c) {
        this.toClass = c;
        this.init();
    }

    public void invoke(T data, AnalysisContext context) {
        JSONObject object = JSONObject.parseObject((String)JSON.toJSONString(data));
        AtomicInteger index = new AtomicInteger(0);
        JSONObject newJson = JSONObject.parseObject((String)this.modelObject.toJSONString());
        this.fieldList.forEach(f -> {
            int andIncrement = index.getAndIncrement();
            newJson.put(f, (Object)(object.get((Object)andIncrement) == null ? "" : object.get((Object)andIncrement).toString()));
        });
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)newJson.toJSONString());
        this.list.add(newJson);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }
}

