/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONArray;
import com.farm.util.HttpSendUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"}, produces={"application/json; charset=UTF-8"})
public class CommonController {
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;

    @PostMapping(value={"/common/post-array"})
    public Object sendCommonPostArray(@RequestBody Map<String, Object> body, @RequestParam(value="params", required=false, defaultValue="") String params, @RequestParam(value="url") String url) throws Exception {
        StringBuilder paramStr = new StringBuilder("");
        if (!StringUtils.isEmpty((Object)params)) {
            paramStr.append("?");
            params = URLDecoder.decode(params, "UTF-8");
            JSONObject paramJson = JSONObject.fromObject((Object)params);
            Iterator iterator = paramJson.keys();
            String param = "";
            while (iterator.hasNext()) {
                param = (String)iterator.next();
                paramStr.append(param).append("=").append(URLEncoder.encode(paramJson.get(param).toString(), "UTF-8")).append("&");
            }
            paramStr.append("hash=").append("x");
            params = paramStr.toString();
        }
        JSONObject bodyJson = JSONObject.fromObject(body);
        return HttpSendUtil.sendHttpPost((String)this.farmServerUrl, (String)url, (String)params, (String)bodyJson.getJSONArray("array").toString());
    }

    @PostMapping(value={"/common/post"})
    public Object sendCommonPost(@RequestBody Map<String, Object> body, @RequestParam(value="params", required=false, defaultValue="") String params, @RequestParam(value="url") String url) throws Exception {
        StringBuilder paramStr = new StringBuilder("");
        if (!StringUtils.isEmpty((Object)params)) {
            paramStr.append("?");
            params = URLDecoder.decode(params, "UTF-8");
            JSONObject paramJson = JSONObject.fromObject((Object)params);
            Iterator iterator = paramJson.keys();
            String param = "";
            while (iterator.hasNext()) {
                param = (String)iterator.next();
                paramStr.append(param).append("=").append(URLEncoder.encode(paramJson.get(param).toString(), "UTF-8")).append("&");
            }
            paramStr.append("hash=").append("x");
            params = paramStr.toString();
        }
        JSONObject bodyJson = JSONObject.fromObject(body);
        return HttpSendUtil.sendHttpPost((String)this.farmServerUrl, (String)url, (String)params, (String)bodyJson.toString());
    }

    @GetMapping(value={"/common/get"})
    public Object sendCommonGet(@RequestParam(value="params", required=false, defaultValue="") String params, @RequestParam(value="url") String url) throws Exception {
        StringBuilder paramStr = new StringBuilder(this.farmServerUrl);
        paramStr.append(url);
        if (!StringUtils.isEmpty((Object)params)) {
            paramStr.append("?");
            params = URLDecoder.decode(params, "UTF-8");
            JSONObject paramJson = JSONObject.fromObject((Object)params);
            Iterator iterator = paramJson.keys();
            String param = "";
            while (iterator.hasNext()) {
                param = (String)iterator.next();
                paramStr.append(param).append("=").append(URLEncoder.encode(paramJson.get(param).toString(), "UTF-8")).append("&");
            }
            paramStr.append("hash=").append("x");
            url = paramStr.toString();
        }
        String result = HttpSendUtil.sendHttpGet((String)url);
        if (url.contains("queryDetailHistoryList")) {
            com.alibaba.fastjson.JSONObject resultObj = com.alibaba.fastjson.JSONObject.parseObject((String)result);
            if (resultObj.getJSONObject("resData").containsKey((Object)"list") && resultObj.getJSONObject("resData").getJSONArray("list").size() > 0) {
                JSONArray jsonArray = resultObj.getJSONObject("resData").getJSONArray("list");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    com.alibaba.fastjson.JSONObject obj = jsonArray.getJSONObject(i);
                    obj.put("datatime", (Object)(obj.getLongValue("datatime") * 1000L));
                }
            }
            return resultObj.toJSONString();
        }
        return result;
    }

    @GetMapping(value={"/common/get-noencode"})
    public Object sendCommonGetNoEncode(@RequestParam(value="params", required=false, defaultValue="") String params, @RequestParam(value="url") String url) throws Exception {
        StringBuilder paramStr = new StringBuilder(this.farmServerUrl);
        paramStr.append(url);
        if (!StringUtils.isEmpty((Object)params)) {
            paramStr.append("?");
            params = URLDecoder.decode(params, "UTF-8");
            JSONObject paramJson = JSONObject.fromObject((Object)params);
            Iterator iterator = paramJson.keys();
            String param = "";
            while (iterator.hasNext()) {
                param = (String)iterator.next();
                paramStr.append(param).append("=").append(paramJson.get(param)).append("&");
            }
            paramStr.append("hash=").append("x");
            url = paramStr.toString();
        }
        return HttpSendUtil.sendHttpGet((String)url);
    }
}

