/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.farm.bean.MarketPrice;
import com.farm.bean.MarketPriceCase;
import com.farm.bean.MarketPriceGroup;
import com.farm.service.MarketPriceService;
import com.farm.util.ResultVo;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/marketPrice"})
public class MarketPriceController {
    @Resource
    private MarketPriceService marketPriceService;

    @PostMapping(value={"/saveOrUpdateMarketPrice"})
    public ResultVo saveOrUpdateMarketPrice(@RequestBody MarketPrice marketPrice) {
        return ResultVo.success((Object)this.marketPriceService.saveOrUpdateMarketPrice(marketPrice));
    }

    @PostMapping(value={"/batchDelete"})
    public ResultVo batchDelete(@RequestParam(value="ids") String ids) {
        return ResultVo.success((Object)this.marketPriceService.batchDelete(ids));
    }

    @PostMapping(value={"/queryMarketPrice"})
    public ResultVo queryMarketPrice(@RequestBody MarketPriceCase marketPriceCase) {
        return ResultVo.success((Object)this.marketPriceService.queryMarketPrice(marketPriceCase));
    }

    @GetMapping(value={"/queryCropManageDetails"})
    public ResultVo queryCropManageDetails(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.marketPriceService.queryCropManageDetails(id));
    }

    @GetMapping(value={"/queryReportDetails"})
    public ResultVo queryReportDetails(@RequestParam(value="businessId") String businessId, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.marketPriceService.queryReportDetails(businessId, pageNum, pageSize));
    }

    @GetMapping(value={"/queryReportPrice"})
    public ResultVo queryReportPrice(@RequestParam(value="businessId") String businessId) {
        return ResultVo.success((Object)this.marketPriceService.queryReportPrice(businessId));
    }

    @PostMapping(value={"/updateReportPrice"})
    public ResultVo updateReportPrice(@RequestParam(value="businessId") String businessId, @RequestParam(value="maxPrice") Long maxPrice, @RequestParam(value="minPrice") Long minPrice, @RequestParam(value="avgPrice") Long avgPrice) {
        return ResultVo.success((Object)this.marketPriceService.updateReportPrice(businessId, maxPrice, minPrice, avgPrice));
    }

    @PostMapping(value={"/revocation"})
    public ResultVo revocation(@RequestParam(value="businessIds") String businessIds) {
        return ResultVo.success((Object)this.marketPriceService.revocation(businessIds));
    }

    @GetMapping(value={"/app/priceGroup"})
    public ResultVo priceGroup(@RequestParam(value="companyId") Integer companyId, @RequestParam(value="cropId") Integer cropId, @RequestParam(value="type", required=false, defaultValue="1") Integer type, @RequestParam(value="day", required=false, defaultValue="90") Integer day) {
        return ResultVo.success((Object)this.marketPriceService.priceGroup(companyId, cropId, type, day));
    }

    @GetMapping(value={"/app/priceGroupAll"})
    public ResultVo priceGroupAll(@RequestParam(value="cropId") Integer cropId, @RequestParam(value="day", required=false, defaultValue="90") Integer day) {
        return ResultVo.success((Object)this.marketPriceService.priceGroupAll(cropId, day));
    }

    @GetMapping(value={"/app/priceGroupDate"})
    public ResultVo priceGroupDate(@RequestParam(value="companyId") Integer companyId, @RequestParam(value="cropId") Integer cropId, @RequestParam(value="type", required=false, defaultValue="1") Integer type, @RequestParam(value="date") String date) {
        return ResultVo.success((Object)this.marketPriceService.priceGroupDate(companyId, cropId, type, date));
    }

    @GetMapping(value={"/app/priceGroupDateAll"})
    public ResultVo priceGroupDateAll(@RequestParam(value="cropId") Integer cropId, @RequestParam(value="date") String date) {
        return ResultVo.success((Object)this.marketPriceService.priceGroupDateAll(cropId, date));
    }

    @PostMapping(value={"/savePriceGroup"})
    public ResultVo savePriceGroup(@RequestBody MarketPriceGroup marketPriceGroup) {
        Integer count = this.marketPriceService.savePriceGroup(marketPriceGroup);
        if (count == -1) {
            return ResultVo.error((String)"\u5df2\u5b58\u5728\u6b64\u6b21\u7c7b\u578b,\u65e0\u6cd5\u6dfb\u52a0");
        }
        if (count == -2) {
            return ResultVo.error((String)"\u8bf7\u6821\u9a8c\u53c2\u6570!");
        }
        return ResultVo.success((Object)1);
    }

    @GetMapping(value={"/queryRegionAll"})
    public ResultVo queryRegionAll() {
        return ResultVo.success((Object)this.marketPriceService.queryRegionAll());
    }
}

