/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.MessageMap;
import com.farm.service.MessageService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ParamAESUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u63d0\u9192\u4fe1\u606f"})
@RequestMapping(value={"/message"})
public class MessageController {
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;
    @Autowired
    private MessageService messageService;

    @PostMapping(value={"/remind"})
    @ApiOperation(value="\u83b7\u53d6\u6c14\u8c61\u3001\u519c\u4e8b\u63d0\u9192\u4fe1\u606f")
    public ResultVo queryMessage(@RequestBody String body) throws IOException {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        String userId = jsonObject.getString("userId");
        String types = jsonObject.getString("types");
        String page = jsonObject.getString("page");
        String pageSize = jsonObject.getString("pageSize");
        List messageIdList = this.messageService.queryMessageIdListByUserId(ParamAESUtil.dealStr((String)userId, (int)2));
        String url = this.farmServerUrl + "messagecenter/phone/getMessageCenterList?hash=1&remindTime=2021-11-08&types=" + types + "&userId=" + userId + "&messageIdString=&page=" + page + "&pageSize=" + pageSize;
        String result = HttpSendUtil.sendHttpGet((String)url);
        JSONArray jsonArray = JSONObject.parseObject((String)result).getJSONObject("resData").getJSONArray("list");
        ArrayList resultList = new ArrayList();
        jsonArray.forEach(item -> {
            Integer id = JSONObject.parseObject((String)item.toString()).getInteger("id");
            if (!messageIdList.contains(id)) {
                resultList.add(item);
            }
        });
        return ResultVo.success(resultList);
    }

    @PostMapping(value={"/confirm-remind"})
    @ApiOperation(value="\u786e\u8ba4\u63d0\u9192")
    public ResultVo confirmMessage(@RequestBody String body) {
        MessageMap messageMap = (MessageMap)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), MessageMap.class);
        this.messageService.confirmMessage(messageMap);
        return ResultVo.success();
    }
}

