/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.depot;

import com.farm.service.DepotDataStatisticsService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u679c\u5e93\u6570\u636e\u7edf\u8ba1"})
@RequestMapping(value={"/depot-statistics"})
public class DepotDataStatisticsController {
    @Autowired
    private DepotDataStatisticsService depotDataStatisticsService;

    @GetMapping(value={"/real-time"})
    @ApiOperation(value="\u5b9e\u65f6\u6570\u636e")
    public ResultVo queryDepotStatisticsRealTime(@RequestParam(value="depotId", required=false) Integer depotId, @RequestParam(value="userId", required=false, defaultValue="") String userId) {
        return ResultVo.success((Object)this.depotDataStatisticsService.queryDepotStatisticsRealTime(depotId, userId));
    }

    @GetMapping(value={"/capacity"})
    @ApiOperation(value="\u5e93\u5bb9\u7edf\u8ba1")
    public ResultVo queryDepotCapacityStatistics(@RequestParam(value="timeType") Integer timeType, @RequestParam(value="time") String time, @RequestParam(value="nowSort", required=false) Integer nowSort, @RequestParam(value="totalSort", required=false) Integer totalSort, @RequestParam(value="depotId", required=false) Integer depotId, @RequestParam(value="town", required=false) String town, @RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="userId", required=false, defaultValue="") String userId) {
        return ResultVo.success((Object)this.depotDataStatisticsService.queryDepotCapacityStatistics(timeType, time, nowSort, totalSort, depotId, userId, town, name));
    }

    @GetMapping(value={"/capacity-list"})
    @ApiOperation(value="\u5e93\u5bb9\u5217\u8868\u7edf\u8ba1")
    public ResultVo queryDepotCapacityStatisticsList(@RequestParam(value="timeType") Integer timeType, @RequestParam(value="time") String time, @RequestParam(value="nowSort", required=false) Integer nowSort, @RequestParam(value="totalSort", required=false) Integer totalSort, @RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.depotDataStatisticsService.queryDepotCapacityStatisticsList(timeType, time, nowSort, totalSort, userId, start, pageSize));
    }

    @GetMapping(value={"/capacity-list/export"})
    @ApiOperation(value="\u5e93\u5bb9\u5217\u8868\u7edf\u8ba1\u5bfc\u51fa")
    public void exportDepotCapacityStatisticsList(HttpServletResponse response, @RequestParam(value="timeType") Integer timeType, @RequestParam(value="time") String time, @RequestParam(value="email", required=false, defaultValue="") String email, @RequestParam(value="depotId", required=false) Integer depotId, @RequestParam(value="nowSort", required=false) Integer nowSort, @RequestParam(value="totalSort", required=false) Integer totalSort, @RequestParam(value="userId", required=false, defaultValue="") String userId) throws IOException {
        this.depotDataStatisticsService.exportDepotCapacityStatisticsList(response, timeType, time, email, depotId, nowSort, totalSort, userId);
    }

    @GetMapping(value={"/storage"})
    @ApiOperation(value="\u51fa\u5165\u5e93\u7edf\u8ba1")
    public ResultVo queryDepotStorageStatistics(@RequestParam(value="timeType") Integer timeType, @RequestParam(value="time") String time, @RequestParam(value="depotId", required=false) Integer depotId, @RequestParam(value="town", required=false) String town, @RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="userId", required=false, defaultValue="") String userId) {
        return ResultVo.success((Object)this.depotDataStatisticsService.queryDepotStorageStatistics(timeType, time, depotId, town, userId, name));
    }

    @GetMapping(value={"/storage-list"})
    @ApiOperation(value="\u51fa\u5165\u5e93\u5217\u8868\u7edf\u8ba1")
    public ResultVo queryDepotStorageStatisticsList(@RequestParam(value="timeType") Integer timeType, @RequestParam(value="time") String time, @RequestParam(value="depotId", required=false) Integer depotId, @RequestParam(value="inSort", required=false) Integer inSort, @RequestParam(value="outSort", required=false) Integer outSort, @RequestParam(value="capacitySort", required=false) Integer capacitySort, @RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.depotDataStatisticsService.queryDepotStorageStatisticsList(timeType, time, depotId, inSort, outSort, capacitySort, userId, start, pageSize));
    }

    @GetMapping(value={"/storage-list/export"})
    @ApiOperation(value="\u51fa\u5165\u5e93\u5217\u8868\u7edf\u8ba1\u5bfc\u51fa")
    public void exportDepotStorageStatisticsList(HttpServletResponse response, @RequestParam(value="timeType") Integer timeType, @RequestParam(value="time") String time, @RequestParam(value="email", required=false, defaultValue="") String email, @RequestParam(value="depotId", required=false) Integer depotId, @RequestParam(value="inSort", required=false) Integer inSort, @RequestParam(value="outSort", required=false) Integer outSort, @RequestParam(value="capacitySort", required=false) Integer capacitySort, @RequestParam(value="userId", required=false, defaultValue="") String userId) throws IOException {
        this.depotDataStatisticsService.exportDepotStorageStatisticsList(response, timeType, time, email, depotId, inSort, outSort, capacitySort, userId);
    }

    @GetMapping(value={"/change-year"})
    @ApiOperation(value="\u5927\u5c4f\u9010\u5e74\u53d8\u5316\u63a5\u53e3")
    public ResultVo queryDepotStatisticsChangeYear(@RequestParam(value="town", required=false) String town, @RequestParam(value="name", required=false, defaultValue="") String name) {
        return ResultVo.success((Object)this.depotDataStatisticsService.queryDepotStatisticsChangeYear(town, name));
    }
}

