/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.depot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DepotInfo;
import com.farm.service.DepotInfoService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u679c\u5e93\u4fe1\u606f"})
@RequestMapping(value={"/depot-info"})
public class DepotInfoController {
    @Autowired
    private DepotInfoService depotInfoService;

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539")
    public ResultVo upsertDepotInfo(@RequestBody String body) {
        DepotInfo depotInfo = (DepotInfo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), DepotInfo.class);
        if (depotInfo.getId() == null) {
            this.depotInfoService.insert(depotInfo);
        } else {
            this.depotInfoService.update(depotInfo);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664/\u505c\u7528")
    public ResultVo disableOrDelDepotInfo(@RequestParam(value="id") Integer id, @RequestParam(value="status", required=false) Integer status) {
        if (status != null) {
            this.depotInfoService.disableDepotInfo(id, status);
        } else {
            this.depotInfoService.deleteDepotInfo(id);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u679c\u5e93\u8be6\u60c5")
    public ResultVo queryDepotInfoDetail(@RequestParam(value="id") Integer id, @RequestParam(value="userId", required=false, defaultValue="") String userId) {
        return ResultVo.success((Object)this.depotInfoService.queryDepotInfoDetail(id, userId));
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875")
    public ResultVo queryDepotInfoPage(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="type", required=false, defaultValue="") String type, @RequestParam(value="phone", required=false, defaultValue="") String phone, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="town", required=false) String town, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.depotInfoService.queryDepotInfoPage(name, type, phone, status, town, start, pageSize));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u679c\u5e93\u5217\u8868")
    public ResultVo queryDepotInfoList() {
        return ResultVo.success((Object)this.depotInfoService.queryDepotInfoList());
    }

    @PostMapping(value={"/upsert-room"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u623f\u95f4")
    public ResultVo updateDepotRoomInfo(@RequestParam(value="depotId", required=false) Integer depotId, @RequestParam(value="id", required=false) Integer id, @RequestParam(value="name") String name) {
        if (id == null) {
            this.depotInfoService.insertDepotRoomInfo(depotId, name);
        } else {
            this.depotInfoService.updateDepotRoomInfo(id, name);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/del-room"})
    @ApiOperation(value="\u5220\u9664\u623f\u95f4")
    public ResultVo deleteDepotRoom(@RequestParam(value="id") Integer id) {
        this.depotInfoService.deleteDepotRoom(id);
        return ResultVo.success();
    }

    @GetMapping(value={"/list-room"})
    @ApiOperation(value="\u623f\u95f4\u5217\u8868")
    public ResultVo queryDepotRoomList(@RequestParam(value="depotId") Integer depotId) {
        return ResultVo.success((Object)this.depotInfoService.queryDepotRoomList(depotId));
    }

    @GetMapping(value={"/list-role"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6240\u80fd\u770b\u5230\u7684\u679c\u5e93")
    public ResultVo queryDepotInfoByUserId(@RequestParam(value="userId") String userId, @RequestParam(value="depotName", required=false, defaultValue="") String depotName, @RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="town", required=false, defaultValue="") String town) {
        return ResultVo.success((Object)this.depotInfoService.queryDepotInfoByUserId(userId, depotName, town, name));
    }

    @GetMapping(value={"/page-role"})
    @ApiOperation(value="\u79fb\u52a8\u7aef\u679c\u5e93\u5206\u9875")
    public ResultVo queryDepotInfoPageByApp(@RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="lng", required=false) Double lng, @RequestParam(value="lat", required=false) Double lat, @RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="capacity", required=false, defaultValue="") String capacity, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.depotInfoService.queryDepotInfoPageByApp(userId, lng, lat, name, capacity, start, pageSize));
    }
}

