/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.depot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DepotRole;
import com.farm.service.DepotRoleService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u679c\u5e93\u89d2\u8272\u914d\u7f6e"})
@RequestMapping(value={"/depot-role"})
public class DepotRoleController {
    @Autowired
    private DepotRoleService depotRoleService;

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539")
    public ResultVo upsertDepotRole(@RequestBody String body) {
        DepotRole depotRole = (DepotRole)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), DepotRole.class);
        if (depotRole.getId() == null) {
            this.depotRoleService.insert(depotRole);
        } else {
            this.depotRoleService.update(depotRole);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664")
    public ResultVo deleteDepotRole(@RequestParam(value="id") Integer id) {
        this.depotRoleService.deleteDepotRole(id);
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u89d2\u8272\u8be6\u60c5")
    public ResultVo queryDepotRoleDetail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.depotRoleService.queryDepotRoleDetail(id));
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875")
    public ResultVo queryDepotRolePage(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="depotIdString", required=false, defaultValue="") String depotIdString, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        List<Object> depotIdList = depotIdString.equals("") ? new ArrayList() : Arrays.asList(depotIdString.split(","));
        return ResultVo.success((Object)this.depotRoleService.queryDepotRolePage(name, depotIdList, start, pageSize));
    }
}

