/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.depot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DepotStorage;
import com.farm.service.DepotStorageService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.ParseException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u679c\u5e93\u5165\u5e93\u51fa\u5e93"})
@RequestMapping(value={"/depot-storage"})
public class DepotStorageController {
    @Autowired
    private DepotStorageService depotStorageService;

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539")
    public ResultVo upsertDepotStorage(@RequestBody String body) throws ParseException {
        DepotStorage depotStorage = (DepotStorage)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), DepotStorage.class);
        if (depotStorage.getId() == null) {
            this.depotStorageService.insert(depotStorage);
        } else {
            this.depotStorageService.update(depotStorage);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u8bb0\u5f55\u8be6\u60c5")
    public ResultVo queryDepotStorageDetail(@RequestParam(value="id") Integer id) throws IOException {
        return ResultVo.success((Object)this.depotStorageService.queryDepotStorageDetail(id));
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664\u8bb0\u5f55")
    public ResultVo deleteDepotStorage(@RequestParam(value="id") Integer id) {
        this.depotStorageService.deleteDepotStorage(id);
        return ResultVo.success();
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875")
    public ResultVo queryDepotStoragePage(@RequestParam(value="depotName", required=false, defaultValue="") String depotName, @RequestParam(value="type", required=false) Integer type, @RequestParam(value="variety", required=false, defaultValue="") String variety, @RequestParam(value="phone", required=false, defaultValue="") String phone, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.depotStorageService.queryDepotStoragePage(depotName, type, variety, phone, start, pageSize));
    }

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u8bb0\u5f55\u5bfc\u51fa")
    public void exportDepotStorage(HttpServletResponse response, @RequestParam(value="depotName", required=false, defaultValue="") String depotName, @RequestParam(value="type", required=false) Integer type, @RequestParam(value="variety", required=false, defaultValue="") String variety, @RequestParam(value="phone", required=false, defaultValue="") String phone) throws IOException {
        this.depotStorageService.exportDepotStorage(response, depotName, type, variety, phone);
    }
}

