/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.dp;

import cn.hutool.core.util.IdUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DpData;
import com.farm.bean.DpDataExport;
import com.farm.bean.annotiaon.TypeCode;
import com.farm.bean.bo.DpDataBo;
import com.farm.bean.dp.DpBase;
import com.farm.bean.dpBean.YFGYZT_14104;
import com.farm.bean.vo.DpChildrenData;
import com.farm.config.DPBeanFactory;
import com.farm.config.ExcelListenerForField;
import com.farm.service.DpDataService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ResultVo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dp/data"})
public class DpDataController {
    @Resource
    private DpDataService dpDataService;
    @Value(value="${cropProblem.url}")
    private String cropProblem;

    @PostMapping(value={"/saveData"})
    public ResultVo saveData(@RequestBody DpDataBo dpData) {
        return ResultVo.success((Object)this.dpDataService.saveData(dpData));
    }

    @GetMapping(value={"/queryDataByTypeCode"})
    public ResultVo queryDataByTypeCode(@RequestParam(value="typeCode") Integer typeCode, @RequestParam(value="businessId", required=false, defaultValue="") String businessId) {
        return ResultVo.success((Object)this.dpDataService.queryDataByTypeCode(typeCode, businessId));
    }

    @GetMapping(value={"/queryDataListByTypeCode"})
    public ResultVo queryDataListByTypeCode(@RequestParam(value="typeCode") Integer typeCode, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="1000") Integer pageSize) {
        return ResultVo.success((Object)this.dpDataService.queryDataListByTypeCode(typeCode, pageNum, pageSize));
    }

    @PostMapping(value={"/delData"})
    public ResultVo delData(@RequestParam(value="uuids") String uuids) {
        return ResultVo.success((Object)this.dpDataService.delData(uuids));
    }

    @PostMapping(value={"/importData"})
    public void importData(@RequestParam(value="file") MultipartFile file, @RequestParam(value="typeCode") String code, @RequestParam(value="businessId", required=false, defaultValue="") String businessId, @RequestParam(value="type", defaultValue="0", required=false) Integer type) throws IOException {
        DpBase beanByCode = DPBeanFactory.getBeanByCode((String)code);
        assert (beanByCode != null);
        ExcelListenerForField excelListener = new ExcelListenerForField(beanByCode.getClass());
        EasyExcel.read((InputStream)file.getInputStream(), beanByCode.getClass(), (ReadListener)excelListener).sheet(Integer.valueOf(0)).doRead();
        List data = JSONObject.parseArray((String)JSONArray.toJSONString((Object)excelListener.list)).toJavaList(beanByCode.getClass());
        if (data.size() == 0) {
            return;
        }
        if (type == 1 && StringUtils.isBlank((String)businessId)) {
            ArrayList childrenData = new ArrayList();
            this.dpDataService.delDataByCode(code);
            DpData dpData = new DpData();
            String dataJson = JSONObject.toJSONString(data.get(data.size() - 1));
            dpData.setTypeCode(Integer.valueOf(code));
            dpData.setData(dataJson);
            this.dpDataService.saveParentData(dpData);
            data.forEach(d -> {
                JSONObject obj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)d));
                DpChildrenData dpChildrenData = new DpChildrenData();
                dpChildrenData.setUuid(IdUtil.simpleUUID());
                dpChildrenData.setParentId(dpData.getId());
                dpChildrenData.setData(JSONObject.toJSONString((Object)d));
                dpChildrenData.setTitle(obj.getString("title"));
                dpChildrenData.setMonth(obj.getString("month"));
                dpChildrenData.setTime(obj.getString("time") == null ? "" : (obj.getString("time").length() > 10 ? obj.getString("time").substring(0, 10) : obj.getString("time")));
                dpChildrenData.setSort(obj.getString("sort"));
                dpChildrenData.setYear(obj.getString("year"));
                childrenData.add(dpChildrenData);
            });
            this.dpDataService.saveChildrenData(childrenData);
        } else if (StringUtils.isNotBlank((String)businessId)) {
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)data), YFGYZT_14104.class);
            this.dpDataService.saveNodeList(list, businessId, code);
        }
    }

    @GetMapping(value={"/exportData"})
    public void exportData(@RequestParam(value="typeCode") String code, @RequestParam(value="type", defaultValue="0", required=false) Integer type, @RequestParam(value="businessId", required=false, defaultValue="") String businessId, HttpServletResponse response) {
        DpBase beanByCode = DPBeanFactory.getBeanByCode((String)code);
        assert (beanByCode != null);
        String fName = beanByCode.getClass().getAnnotation(TypeCode.class).fileName();
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(fName, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        DpDataExport dpDataExport = this.dpDataService.selectExportData(code, businessId);
        if (dpDataExport == null || type == 0) {
            EasyExcel.write((OutputStream)response.getOutputStream(), beanByCode.getClass()).sheet().doWrite(new ArrayList());
            return;
        }
        JSONArray array = new JSONArray();
        if (dpDataExport.getChildrenList().size() > 0) {
            dpDataExport.getChildrenList().forEach(c -> array.add((Object)JSONObject.parseObject((String)c.getData())));
        } else {
            array.add((Object)JSONObject.parseObject((String)dpDataExport.getData()));
        }
        List dataList = array.toJavaList(beanByCode.getClass());
        EasyExcel.write((OutputStream)response.getOutputStream(), beanByCode.getClass()).sheet().doWrite(dataList);
    }

    @GetMapping(value={"/queryCropProblem"})
    public Object queryCropProblem(@RequestParam(value="cropName") String cropName, @RequestParam(value="companyId") String companyId, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="100") Integer pageSize) {
        StringBuilder str = new StringBuilder();
        str.append(this.cropProblem);
        str.append("?cropName=" + cropName);
        str.append("&companyId=" + companyId);
        str.append("&pageNum=" + pageNum);
        str.append("&pageSize=" + pageSize);
        String s = HttpSendUtil.sendHttpGet((String)str.toString());
        return s;
    }
}

